/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.ide.review.compare;

import com.smartbear.ccollab.client.CollabClientServerConnectivityException;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.IReviewFile;
import com.smartbear.ccollab.datamodel.client.IVersion;
import com.smartbear.ccollab.datamodel.client.NoLicenseAvailableException;
import com.smartbear.ccollab.datamodel.client.ReviewAccessException;
import com.smartbear.collaborator.jobs.FileRefreshJob;
import com.smartbear.collaborator.resources.ResourcesUtil;
import com.smartbear.collaborator.ui.ide.review.compare.CompareModel;
import com.smartbear.collaborator.ui.review.compare.AbstractCompareConfig;
import com.smartbear.collaborator.ui.review.compare.ICompareModel;
import com.smartbear.collections.Pair;
import com.smartbear.util.SmartBearUtils;
import java.io.File;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;

public class CompareConfig
extends AbstractCompareConfig {
    public static final int LOCAL_FILE_VERSION_ID = -1;
    private final int afterVersionId;
    private final Integer beforeVersionId;

    public CompareConfig(int reviewId, int afterVersionId) {
        this(reviewId, afterVersionId, null);
    }

    public CompareConfig(int reviewId, int afterVersionId, int beforeVersionId) {
        this(reviewId, afterVersionId, (Integer)beforeVersionId);
    }

    private CompareConfig(int reviewId, int afterVersionId, Integer beforeVersionId) {
        super(reviewId, afterVersionId);
        this.afterVersionId = afterVersionId;
        this.beforeVersionId = beforeVersionId;
    }

    public ICompareModel createModel(IWorkbenchPart part, IProgressMonitor monitor) throws CollabClientServerConnectivityException, ReviewAccessException, NoLicenseAvailableException {
        IVersion beforeVersion;
        IVersion afterVersion;
        Pair serverModel = this.loadServerModel(monitor);
        IClientSystemGlobals clientSystemGlobals = (IClientSystemGlobals)serverModel.getA();
        IReviewFile reviewFile = (IReviewFile)serverModel.getB();
        FileRefreshJob refreshJob = this.createRefreshJob(reviewFile, part);
        IFile afterFile = null;
        if (this.afterVersionId == -1) {
            afterVersion = (IVersion)SmartBearUtils.getFirstObject((Collection)reviewFile.getChangedVersions());
            File localFile = afterVersion.getLocalFile();
            if (localFile != null) {
                afterFile = ResourcesUtil.findFile((File)localFile);
            }
        } else {
            afterVersion = reviewFile.getVersion(this.afterVersionId);
            afterFile = null;
        }
        IFile beforeFile = null;
        if (this.beforeVersionId != null && this.beforeVersionId == -1) {
            beforeVersion = (IVersion)SmartBearUtils.getFirstObject((Collection)reviewFile.getChangedVersions());
            File localFile = beforeVersion.getLocalFile();
            if (localFile != null) {
                beforeFile = ResourcesUtil.findFile((File)localFile);
            }
        } else {
            beforeVersion = this.beforeVersionId == null ? reviewFile.getDefaultPrevVersion() : reviewFile.getVersion(this.beforeVersionId.intValue());
            beforeFile = null;
        }
        return new CompareModel(refreshJob, clientSystemGlobals, reviewFile, afterVersion, afterFile, beforeVersion, beforeFile);
    }
}

