/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.ide.review.compare;

import com.google.common.base.Preconditions;
import com.smartbear.ccollab.binary.ZoomScale;
import com.smartbear.ccollab.client.CollabClientServerConnectivityException;
import com.smartbear.ccollab.datamodel.Product;
import com.smartbear.ccollab.datamodel.client.ChangeType;
import com.smartbear.ccollab.datamodel.client.FileType;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.IConversation;
import com.smartbear.ccollab.datamodel.client.ILocator;
import com.smartbear.ccollab.datamodel.client.IReviewFile;
import com.smartbear.ccollab.datamodel.client.IVersion;
import com.smartbear.ccollab.datamodel.client.OverallLocator;
import com.smartbear.collaborator.ClientContentManager;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.NotAllowedToAccessVersionContentException;
import com.smartbear.collaborator.jobs.FileRefreshJob;
import com.smartbear.collaborator.resources.LocatorMapper;
import com.smartbear.collaborator.resources.ResourcesUtil;
import com.smartbear.collaborator.ui.ide.review.compare.CompareConfig;
import com.smartbear.collaborator.ui.ide.review.compare.ReviewFileCompareEditorInput;
import com.smartbear.collaborator.ui.review.IConversationContext;
import com.smartbear.collaborator.ui.review.compare.AbstractCompareModel;
import com.smartbear.collaborator.ui.review.compare.ICompareConfig;
import com.smartbear.collaborator.ui.review.compare.ICompareModel;
import com.smartbear.collaborator.ui.review.compare.ICompareModelListener;
import com.smartbear.collaborator.ui.review.compare.ServerCompareVersion;
import com.smartbear.collaborator.ui.review.compare.ServerContentCompareVersion;
import com.smartbear.collaborator.ui.review.compare.ServerPageCompareVersion;
import com.smartbear.collections.Pair;
import com.smartbear.jface.ComboViewer2;
import com.smartbear.jface.IBaseLabelProvider2;
import com.smartbear.jface.ILabelProvider2;
import com.smartbear.jface.ISelectionChangedListener2;
import com.smartbear.jface.IStructuredContentProvider2;
import com.smartbear.jface.LabelProvider2;
import com.smartbear.jface.MultiLabelProvider;
import com.smartbear.jface.MultiViewerComparator;
import com.smartbear.jface.StructuredContentProvider2;
import com.smartbear.jface.StructuredViewer2;
import com.smartbear.jface.ViewerComparator2;
import com.smartbear.util.ListenerList;
import com.smartbear.util.SmartBearUtils;
import com.smartbear.util.commons.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;

public class CompareModel
extends AbstractCompareModel {
    private final ListenerList<ICompareModelListener> listeners = new ListenerList();
    private final IVersion afterVersion;
    private final IFile afterFile;
    private final IVersion beforeVersion;
    private final IFile beforeFile;
    private final int AFTER = 1;
    private final int BEFORE = 2;
    private LocatorMapper fileLocatorMapper;
    private IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (CompareModel.this.fileLocatorMapper == null) {
                return;
            }
            boolean afterFileModified = CompareModel.this.fileLocatorMapper.isDifferentFromVersion(CompareModel.this.afterVersion.getId(), CompareModel.this.afterVersion.getContentMd5(), (IProgressMonitor)new NullProgressMonitor());
            for (ICompareModelListener listener : CompareModel.this.listeners.getListeners()) {
                listener.afterFileModifiedChanged(afterFileModified);
            }
        }
    };

    public CompareModel(FileRefreshJob refreshJob, IClientSystemGlobals clientSystemGlobals, IReviewFile reviewFile, IVersion afterVersion, IFile afterFile, IVersion beforeVersion, IFile beforeFile) {
        super(refreshJob, clientSystemGlobals, reviewFile);
        this.afterVersion = afterVersion;
        this.beforeVersion = beforeVersion;
        this.afterFile = afterFile;
        this.beforeFile = beforeFile;
        Preconditions.checkArgument((afterVersion != null ? 1 : 0) != 0, (Object)"afterVersion must not be null");
        Preconditions.checkArgument((beforeVersion != null ? 1 : 0) != 0, (Object)"beforeVersion must not be null");
    }

    public ICompareConfig getConfig() {
        return new CompareConfig(this.getReviewFile().getId(), this.afterFile != null ? -1 : this.afterVersion.getId(), this.beforeFile != null ? -1 : this.beforeVersion.getId());
    }

    public String getTitle() {
        return FilenameUtils.getName((String)this.afterVersion.getPath());
    }

    public void configure(CompareConfiguration compareConfiguration) {
        if (ChangeType.DELETED.equals((Object)this.afterVersion.getChangeType())) {
            compareConfiguration.setRightLabel(this.afterVersion.getTitle());
        } else {
            compareConfiguration.setRightLabel(this.beforeVersion.getTitle());
            compareConfiguration.setLeftLabel(this.afterVersion.getTitle());
        }
    }

    public Object prepareInput(IProgressMonitor monitor) throws CoreException, CollabClientServerConnectivityException, IOException, NotAllowedToAccessVersionContentException {
        DiffNode input;
        String errorMessageProductName = "We're sorry, " + Product.current.getProductName();
        String errorMessageEnterprise = "however, the Enterprise edition does. If you would like to speak with our sales team about a trial upgrade, please send an email to collaborator-team@smartbear.com.";
        switch (this.afterVersion.getFileType()) {
            case DOCUMENT: {
                if (!Product.getFeatures().supportsDocumentReview()) {
                    throw new NotAllowedToAccessVersionContentException(errorMessageProductName + " does not support reviews of document files; " + errorMessageEnterprise);
                }
                input = this.prepareInputDocument(monitor);
                break;
            }
            case SPREADSHEET: {
                if (!Product.getFeatures().supportsSpreadsheetReview()) {
                    throw new NotAllowedToAccessVersionContentException(errorMessageProductName + " does not support reviews of spreadsheet files; " + errorMessageEnterprise);
                }
                input = this.prepareInputContent(monitor);
                break;
            }
            case IMAGE: {
                if (!Product.getFeatures().supportsImageReview()) {
                    throw new NotAllowedToAccessVersionContentException(errorMessageProductName + " does not support reviews of image files; " + errorMessageEnterprise);
                }
                input = this.prepareInputContent(monitor);
                break;
            }
            case URL: {
                input = this.prepareInputUrl();
                break;
            }
            default: {
                input = this.prepareInputContent(monitor);
            }
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DiffNode prepareInputContent(IProgressMonitor monitor) throws CoreException, CollabClientServerConnectivityException, IOException, NotAllowedToAccessVersionContentException {
        int diffKind;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.afterFile == null ? 100 : 200));
        if (this.afterFile != null) {
            this.fileLocatorMapper = new LocatorMapper(this.afterFile, this.getReviewFile().getId());
            this.fileLocatorMapper.promoteToFile((Collection)this.getReviewFile().getConversations(), (IProgressMonitor)progress.newChild(100));
            this.afterFile.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        }
        progress.setWorkRemaining(100);
        ClientContentManager contentManager = Collaborator.getContentManager();
        ITypedElement afterCompareVersion = null;
        if (this.afterFile == null) {
            if (!ChangeType.DELETED.equals((Object)this.afterVersion.getChangeType())) {
                progress.subTask("Downloading " + this.afterVersion.getTitle());
                ClientContentManager.IContentAccessor content = contentManager.getContent(this.afterVersion, (IProgressMonitor)progress.newChild(50));
                afterCompareVersion = new ServerContentCompareVersion(this.afterVersion, content);
            }
        } else {
            afterCompareVersion = SaveableCompareEditorInput.createFileElement((IFile)this.afterFile);
        }
        progress.setWorkRemaining(50);
        ITypedElement beforeCompareVersion = null;
        if (this.beforeFile == null) {
            if (!ChangeType.ADDED.equals((Object)this.afterVersion.getChangeType()) || this.beforeVersion.getId() != this.afterVersion.getId()) {
                progress.subTask("Downloading " + this.beforeVersion.getTitle());
                ClientContentManager.IContentAccessor content = contentManager.getContent(this.beforeVersion, (IProgressMonitor)progress.newChild(50));
                beforeCompareVersion = new ServerContentCompareVersion(this.beforeVersion, content);
            }
        } else {
            beforeCompareVersion = SaveableCompareEditorInput.createFileElement((IFile)this.beforeFile);
        }
        if (this.afterFile == null && this.beforeFile == null) {
            if (afterCompareVersion != null) {
                diffKind = beforeCompareVersion != null ? (this.afterVersion.getContentMd5().equals(this.beforeVersion.getContentMd5()) ? 0 : 3) : 1;
            } else {
                if (beforeCompareVersion == null) {
                    throw new IllegalStateException("Both after and before versions are null");
                }
                diffKind = 2;
            }
        } else {
            InputStream afterStream = null;
            InputStream beforeStream = null;
            try {
                afterStream = afterCompareVersion == null ? null : ((IStreamContentAccessor)afterCompareVersion).getContents();
                beforeStream = beforeCompareVersion == null ? null : ((IStreamContentAccessor)beforeCompareVersion).getContents();
                diffKind = this.contentsEqual(afterStream, beforeStream) ? 0 : 3;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(afterStream);
                IOUtils.closeQuietly(beforeStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)afterStream);
            IOUtils.closeQuietly((InputStream)beforeStream);
        }
        DiffNode diffNode = new DiffNode(diffKind, null, afterCompareVersion, beforeCompareVersion);
        if (this.afterVersion.getFileType() == FileType.DOCUMENT && this.beforeVersion.getFileType() == FileType.DOCUMENT) {
            for (int page = 0; page < Math.max(this.afterVersion.getNumPages(), this.beforeVersion.getNumPages()); ++page) {
                int kind = this.afterVersion.getNumPages() <= page ? 1 : (this.beforeVersion.getNumPages() <= page ? 2 : 3);
                DiffNode pageNode = new DiffNode(kind);
                if (kind != 1) {
                    pageNode.setLeft((ITypedElement)new ServerPageCompareVersion(this.afterVersion, page, contentManager.getPageContent(this.afterVersion, page + 1, ZoomScale.ONEHUNDRED_PERCENT, (IProgressMonitor)new NullProgressMonitor())));
                }
                if (kind != 2) {
                    pageNode.setRight((ITypedElement)new ServerPageCompareVersion(this.beforeVersion, page, contentManager.getPageContent(this.beforeVersion, page + 1, ZoomScale.ONEHUNDRED_PERCENT, (IProgressMonitor)new NullProgressMonitor())));
                }
                diffNode.add((IDiffElement)pageNode);
            }
        }
        return diffNode;
    }

    private DiffNode prepareInputDocument(IProgressMonitor monitor) throws CollabClientServerConnectivityException, IOException, NotAllowedToAccessVersionContentException {
        ServerCompareVersion afterCompareVersion = null;
        if (!ChangeType.DELETED.equals((Object)this.afterVersion.getChangeType())) {
            afterCompareVersion = new ServerCompareVersion(this.afterVersion);
        }
        ServerCompareVersion beforeCompareVersion = null;
        if (!ChangeType.ADDED.equals((Object)this.afterVersion.getChangeType()) || this.beforeVersion.getId() != this.afterVersion.getId()) {
            beforeCompareVersion = new ServerCompareVersion(this.beforeVersion);
        }
        DiffNode documentNode = new DiffNode(3, null, (ITypedElement)afterCompareVersion, (ITypedElement)beforeCompareVersion);
        for (int page = 0; page < Math.max(this.afterVersion.getNumPages(), this.beforeVersion.getNumPages()); ++page) {
            int kind = this.afterVersion.getNumPages() <= page ? 1 : (this.beforeVersion.getNumPages() <= page ? 2 : 3);
            DiffNode pageNode = new DiffNode(kind);
            if (kind != 1) {
                pageNode.setLeft((ITypedElement)new ServerPageCompareVersion(this.afterVersion, page, Collaborator.getContentManager().getPageContent(this.afterVersion, page + 1, ZoomScale.ONEHUNDRED_PERCENT, (IProgressMonitor)new NullProgressMonitor())));
            }
            if (kind != 2) {
                pageNode.setRight((ITypedElement)new ServerPageCompareVersion(this.beforeVersion, page, Collaborator.getContentManager().getPageContent(this.beforeVersion, page + 1, ZoomScale.ONEHUNDRED_PERCENT, (IProgressMonitor)new NullProgressMonitor())));
            }
            documentNode.add((IDiffElement)pageNode);
        }
        return documentNode;
    }

    private DiffNode prepareInputUrl() {
        ServerCompareVersion compareVersion = new ServerCompareVersion((IVersion)ObjectUtils.defaultIfNull((Object)this.afterVersion, (Object)this.beforeVersion));
        return new DiffNode(3, null, (ITypedElement)compareVersion, null);
    }

    protected boolean contentsEqual(InputStream after, InputStream before) throws IOException {
        int beforeByte;
        int afterByte;
        if (after == null && before == null) {
            return true;
        }
        if (after == null) {
            return false;
        }
        if (before == null) {
            return false;
        }
        do {
            afterByte = after.read();
            beforeByte = before.read();
            if (afterByte != -1 || beforeByte != -1) continue;
            return true;
        } while (afterByte == beforeByte);
        return false;
    }

    public ILocator getLocator(IConversation conversation) {
        if (this.fileLocatorMapper != null) {
            return (ILocator)this.fileLocatorMapper.promoteToFile(Collections.singleton(conversation), (IProgressMonitor)new NullProgressMonitor()).get(conversation);
        }
        if (OverallLocator.INSTANCE.equals((Object)conversation.getOriginLocator())) {
            return OverallLocator.INSTANCE;
        }
        return conversation.getLocator(this.afterVersion);
    }

    public IVersion getNewConversationVersion() {
        return this.afterVersion;
    }

    public void configureVersionSelect(CCombo afterCombo, CCombo beforeCombo, final IReusableEditor editor, final IConversationContext convoContext) {
        final StructuredViewer2<IReviewFile, Object> afterViewer = this.createVersionSelectViewer(afterCombo, 1);
        final StructuredViewer2<IReviewFile, Object> beforeViewer = this.createVersionSelectViewer(beforeCombo, 2);
        afterViewer.setSelection(Collections.singletonList(this.afterFile == null ? this.afterVersion : this.afterFile));
        beforeViewer.setSelection(Collections.singletonList(this.beforeFile == null ? this.beforeVersion : this.beforeFile));
        ISelectionChangedListener2<Object> selectionListener = new ISelectionChangedListener2<Object>(){

            public void selectionChanged(List<Object> unused) {
                Pair<IVersion, IFile> after = CompareModel.this.resolveSelection((StructuredViewer2<IReviewFile, Object>)afterViewer);
                Pair<IVersion, IFile> before = CompareModel.this.resolveSelection((StructuredViewer2<IReviewFile, Object>)beforeViewer);
                CompareModel newCompareModel = new CompareModel(CompareModel.this.getRefreshJob(), CompareModel.this.getClientSystemGlobals(), CompareModel.this.getReviewFile(), (IVersion)after.getA(), (IFile)after.getB(), (IVersion)before.getA(), (IFile)before.getB());
                ReviewFileCompareEditorInput input = new ReviewFileCompareEditorInput(editor.getEditorSite().getPage(), (ICompareModel)newCompareModel, convoContext.getCurrentLocator());
                editor.setInput((IEditorInput)input);
                input.broadcastReconsiderPart();
                CompareModel.this.dispose();
            }
        };
        afterViewer.addPostSelectionChangedListener((ISelectionChangedListener2)selectionListener);
        beforeViewer.addPostSelectionChangedListener((ISelectionChangedListener2)selectionListener);
    }

    private Pair<IVersion, IFile> resolveSelection(StructuredViewer2<IReviewFile, Object> viewer) {
        Object file;
        IVersion version;
        Object selection = SmartBearUtils.getFirstObject((Collection)viewer.getSelection());
        if (selection instanceof IVersion) {
            version = (IVersion)selection;
            file = null;
        } else {
            version = (IVersion)SmartBearUtils.getFirstObject((Collection)this.getReviewFile().getVersions());
            if (selection instanceof IFile) {
                file = (IFile)selection;
            } else {
                LocalFileSelectionDialog dialog = new LocalFileSelectionDialog(viewer.getControl().getShell(), FilenameUtils.getName((String)version.getPath()));
                dialog.setTitle("Select local file");
                dialog.setAllowUserToToggleDerived(true);
                dialog.setBlockOnOpen(true);
                file = dialog.open() == 0 ? (IFile)SmartBearUtils.getFirstObject((Object[])dialog.getResult()) : null;
            }
        }
        return Pair.of((Object)version, file);
    }

    private StructuredViewer2<IReviewFile, Object> createVersionSelectViewer(CCombo combo, final int side) {
        ComboViewer2 viewer = ComboViewer2.create((CCombo)combo);
        MultiLabelProvider labelProvider = new MultiLabelProvider();
        labelProvider.set(IVersion.class, (ILabelProvider2)new LabelProvider2<IVersion>(){

            public String getText(IVersion element) {
                return element.getTitle();
            }
        });
        if (side == 1) {
            labelProvider.set(IFile.class, (ILabelProvider2)new LabelProvider2<IFile>(){

                public String getText(IFile element) {
                    return "Local File";
                }
            });
            labelProvider.set(PromptForLocalFile.class, (ILabelProvider2)new LabelProvider2<PromptForLocalFile>(){

                public String getText(PromptForLocalFile element) {
                    return "Local File...";
                }
            });
        }
        viewer.setLabelProvider((IBaseLabelProvider2)labelProvider);
        viewer.setContentProvider((IStructuredContentProvider2)new StructuredContentProvider2<IReviewFile, Object>(){

            public Collection<? extends Object> getElements(IReviewFile reviewFile) {
                ArrayList versions = reviewFile.getChangedVersions();
                IVersion latestVersion = (IVersion)SmartBearUtils.getFirstObject((Collection)versions);
                ArrayList<Object> elements = new ArrayList<Object>();
                if (CompareModel.this.afterFile != null || CompareModel.this.beforeFile != null) {
                    if (side == 1) {
                        elements.add(ObjectUtils.defaultIfNull((Object)CompareModel.this.afterFile, (Object)CompareModel.this.beforeFile));
                    }
                } else if (latestVersion.getFileType() != FileType.DOCUMENT && side == 1) {
                    IFile resource = null;
                    File localFile = latestVersion.getLocalFile();
                    if (localFile != null) {
                        resource = ResourcesUtil.findFile((File)localFile);
                    }
                    if (resource != null) {
                        elements.add(resource);
                    } else {
                        elements.add((Object)PromptForLocalFile.INSTANCE);
                    }
                }
                elements.addAll(versions);
                return elements;
            }
        });
        MultiViewerComparator viewerComparator = new MultiViewerComparator();
        viewerComparator.set(Object.class, (ViewerComparator2)new ViewerComparator2<Object>(){

            public int category(Object element) {
                if (element instanceof IFile) {
                    return 1;
                }
                if (element instanceof PromptForLocalFile) {
                    return 2;
                }
                return 3;
            }
        });
        viewerComparator.set(IVersion.class, (ViewerComparator2)new ViewerComparator2<IVersion>(){

            public int compare(Viewer viewer, IVersion v1, IVersion v2) {
                return v1.getDate().compareTo(v2.getDate());
            }
        });
        viewer.setInput((Object)this.getReviewFile());
        return viewer;
    }

    public boolean isAfterVersionLocalFile() {
        return this.afterFile != null;
    }

    public boolean isAfterFileModified() {
        return this.fileLocatorMapper != null && this.fileLocatorMapper.isDifferentFromVersion(this.afterVersion.getId(), this.afterVersion.getContentMd5(), (IProgressMonitor)new NullProgressMonitor());
    }

    public void addCompareModelListener(ICompareModelListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeCompareModelListener(ICompareModelListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void dispose() {
        if (this.afterFile != null && this.resourceChangeListener != null) {
            this.afterFile.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        }
    }

    public IFile getLocalFile() {
        return this.afterFile;
    }

    static enum PromptForLocalFile {
        INSTANCE;

    }

    private final class LocalFileSelectionDialog
    extends ResourceListSelectionDialog {
        private final String name;

        private LocalFileSelectionDialog(Shell parentShell, String name) {
            super(parentShell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
            this.name = name;
        }

        protected String adjustPattern() {
            String pattern = super.adjustPattern();
            if (StringUtils.isBlank((String)pattern)) {
                pattern = this.name;
            }
            return pattern;
        }

        public void create() {
            super.create();
            this.refresh(true);
        }
    }
}

