/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.ide.review.compare;

import com.google.common.base.Objects;
import com.smartbear.ccollab.client.CollabClientServerConnectivityException;
import com.smartbear.ccollab.datamodel.Product;
import com.smartbear.ccollab.datamodel.client.FileSource;
import com.smartbear.ccollab.datamodel.client.FileType;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.IConversationProvider;
import com.smartbear.ccollab.datamodel.client.ILocator;
import com.smartbear.ccollab.datamodel.client.IVersion;
import com.smartbear.ccollab.datamodel.client.NoLicenseAvailableException;
import com.smartbear.ccollab.datamodel.client.OverallLocator;
import com.smartbear.ccollab.datamodel.client.ReviewAccessException;
import com.smartbear.collaborator.NotAllowedToAccessVersionContentException;
import com.smartbear.collaborator.jobs.ClientModelRefreshJob;
import com.smartbear.collaborator.ui.ActivityListener;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ErrorUI;
import com.smartbear.collaborator.ui.review.IConversationContext;
import com.smartbear.collaborator.ui.review.compare.BaseCompareViewer;
import com.smartbear.collaborator.ui.review.compare.ContentMergeCompareViewer;
import com.smartbear.collaborator.ui.review.compare.ICompareConfig;
import com.smartbear.collaborator.ui.review.compare.ICompareModel;
import com.smartbear.collaborator.ui.review.compare.ICompareViewer;
import com.smartbear.collaborator.ui.review.compare.ImageMergeCompareViewer;
import com.smartbear.collaborator.ui.review.compare.LiveUrlViewer;
import com.smartbear.collaborator.ui.review.compare.ServerCompareVersion;
import com.smartbear.collaborator.ui.review.compare.TextMergeCompareViewer;
import com.smartbear.collaborator.ui.util.PartAdapter2;
import com.smartbear.collaborator.ui.views.AbstractContextView;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.ImageMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchSite;

public class ReviewFileCompareEditorInput
extends SaveableCompareEditorInput {
    private static final ICompareInput ERROR_COMPARE_RESULT = new DiffNode(0);
    private final ICompareConfig compareConfig;
    private final ILocator initialLocation;
    ICompareModel compareModel;
    private String compareErrorMessage;
    private Throwable compareError;
    private ICompareViewer compareViewer;

    public ReviewFileCompareEditorInput(IWorkbenchPage page, ICompareConfig compareConfig) {
        this(page, compareConfig, (ILocator)OverallLocator.INSTANCE);
    }

    public ReviewFileCompareEditorInput(IWorkbenchPage page, ICompareConfig compareConfig, ILocator initialLocation) {
        super(new CompareConfiguration(), page);
        this.compareConfig = compareConfig;
        this.initialLocation = initialLocation;
    }

    ReviewFileCompareEditorInput(IWorkbenchPage page, ICompareModel compareModel, ILocator initialLocation) {
        this(page, compareModel.getConfig(), initialLocation);
        this.compareModel = compareModel;
    }

    public void setContainer(ICompareContainer container) {
        super.setContainer(container);
        this.getWorkbenchPart().getSite().getPage().addPartListener((IPartListener2)new PartAdapter2(){

            public void partClosed(IWorkbenchPartReference partRef) {
                if (ReviewFileCompareEditorInput.this.compareModel != null && Objects.equal((Object)partRef.getPart(true), (Object)ReviewFileCompareEditorInput.this.getWorkbenchPart())) {
                    ReviewFileCompareEditorInput.this.compareModel.dispose();
                }
            }
        });
    }

    private IReusableEditor getEditor() {
        return (IReusableEditor)this.getWorkbenchPart();
    }

    public boolean canRunAsJob() {
        return true;
    }

    protected ICompareInput prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        throw new RuntimeException("prepareCompareInput not implemented");
    }

    protected void fireInputChange() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object prepareInput(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Comparing files", (int)100);
        try {
            if (this.compareModel == null) {
                progress.subTask("Loading file information from " + Product.current.getProductName() + " Server");
                this.compareModel = this.compareConfig.createModel((IWorkbenchPart)this.getEditor(), (IProgressMonitor)progress.newChild(20));
            }
            progress.setWorkRemaining(80);
            this.setTitle(this.compareModel.getTitle());
            this.compareModel.configure(this.getCompareConfiguration());
            Object object = this.compareModel.prepareInput((IProgressMonitor)progress.newChild(80));
            return object;
        }
        catch (CollabClientServerConnectivityException e) {
            this.compareError = e;
            this.compareErrorMessage = "Could not connect to server: " + e.getMessage();
            ICompareInput iCompareInput = ERROR_COMPARE_RESULT;
            return iCompareInput;
        }
        catch (CoreException e) {
            this.compareError = e;
            ICompareInput iCompareInput = ERROR_COMPARE_RESULT;
            return iCompareInput;
        }
        catch (IOException e) {
            this.compareError = e;
            ICompareInput iCompareInput = ERROR_COMPARE_RESULT;
            return iCompareInput;
        }
        catch (ReviewAccessException e) {
            this.compareError = e;
            this.compareErrorMessage = "Not allowed to access Review " + this.compareConfig.getReviewId();
            ICompareInput iCompareInput = ERROR_COMPARE_RESULT;
            return iCompareInput;
        }
        catch (NotAllowedToAccessVersionContentException e) {
            this.compareError = e;
            this.compareErrorMessage = "Not allowed to access file content: " + e.getMessage();
            ICompareInput iCompareInput = ERROR_COMPARE_RESULT;
            return iCompareInput;
        }
        catch (NoLicenseAvailableException e) {
            this.compareError = e;
            this.compareErrorMessage = e.getMessage();
            ICompareInput iCompareInput = ERROR_COMPARE_RESULT;
            return iCompareInput;
        }
        finally {
            if (StringUtils.isNotBlank((String)this.compareErrorMessage) || this.compareError != null) {
                CollaboratorUI.log((String)this.compareErrorMessage, (Throwable)this.compareError);
            }
            progress.done();
        }
    }

    public Control createContents(Composite parent) {
        if (this.getCompareResult() == ERROR_COMPARE_RESULT) {
            ErrorUI errorUI = new ErrorUI(parent);
            errorUI.setError(this.compareErrorMessage, this.compareError);
            return errorUI;
        }
        Control contents = super.createContents(parent);
        contents.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ReviewFileCompareEditorInput.this.compareModel = null;
                ReviewFileCompareEditorInput.this.compareViewer = null;
            }
        });
        if (this.compareModel.getNewConversationVersion().getFileType() == FileType.DOCUMENT) {
            this.getNavigator().selectChange(true);
        }
        return contents;
    }

    public void saveChanges(IProgressMonitor monitor) throws CoreException {
        RuntimeException re;
        super.saveChanges(monitor);
        FileOutputStream out = null;
        File file = null;
        try {
            int len;
            InputStream localStream;
            IFile iFile = this.compareModel.getLocalFile();
            if (iFile == null) {
                return;
            }
            ITypedElement localVersion = SaveableCompareEditorInput.createFileElement((IFile)iFile);
            InputStream inputStream = localStream = localVersion == null ? null : ((IStreamContentAccessor)localVersion).getContents();
            if (localStream == null) {
                return;
            }
            if (localStream.available() <= 0) {
                return;
            }
            file = new File(iFile.getLocation().toOSString());
            out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = localStream.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
        catch (FileNotFoundException e) {
            re = new RuntimeException("Could not find the local file:" + (file == null ? "null" : file.getAbsolutePath()), e);
            CollaboratorUI.log((String)re.getMessage(), (Throwable)re.fillInStackTrace());
            throw re;
        }
        catch (IOException error) {
            re = new RuntimeException("IOException occurs, the local file:" + (file == null ? "null" : file.getAbsolutePath()), error);
            CollaboratorUI.log((String)re.getMessage(), (Throwable)re.fillInStackTrace());
            throw re;
        }
        finally {
            this.flushViewers(monitor);
        }
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        FileSource fileSource = ((ServerCompareVersion)input.getLeft()).getVersion().getFileSource();
        Object viewer = input.getLeft() instanceof ServerCompareVersion && fileSource == FileSource.URL || fileSource == FileSource.SIMULINK ? (oldViewer instanceof LiveUrlViewer ? oldViewer : new LiveUrlViewer(parent)) : super.findContentViewer(oldViewer, input, parent);
        if (this.compareViewer == null || this.compareViewer.getViewer() != viewer) {
            if (viewer instanceof ImageMergeViewer) {
                this.compareViewer = ImageMergeCompareViewer.create((ImageMergeViewer)((ImageMergeViewer)viewer), (ICompareModel)this.compareModel, (IReusableEditor)this.getEditor());
            } else if (viewer instanceof TextMergeViewer) {
                this.compareViewer = TextMergeCompareViewer.create((TextMergeViewer)((TextMergeViewer)viewer), (ICompareModel)this.compareModel, (IReusableEditor)this.getEditor());
            } else if (viewer instanceof ContentMergeViewer) {
                this.compareViewer = ContentMergeCompareViewer.create((ContentMergeViewer)((ContentMergeViewer)viewer), (ICompareModel)this.compareModel, (IReusableEditor)this.getEditor());
            } else if (viewer != null) {
                this.compareViewer = BaseCompareViewer.create((Viewer)viewer, (ICompareModel)this.compareModel, (IWorkbenchSite)this.getEditor().getEditorSite());
            } else {
                CollaboratorUI.log((String)("No viewer found for input " + input), null);
            }
            this.broadcastReconsiderPart();
        }
        return viewer;
    }

    public void broadcastReconsiderPart() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractContextView.broadcastReconsiderPart((IWorkbenchPart)ReviewFileCompareEditorInput.this.getEditor());
            }
        });
    }

    public Object getAdapter(Class adapter) {
        if (this.compareModel != null) {
            if (IClientSystemGlobals.class.equals((Object)adapter)) {
                return this.compareModel.getClientSystemGlobals();
            }
            if (IConversationProvider.class.equals((Object)adapter)) {
                return this.compareModel.getReviewFile();
            }
            if (IVersion.class.equals((Object)adapter)) {
                return this.compareModel.getNewConversationVersion();
            }
            if (ActivityListener.class.equals((Object)adapter)) {
                return new ActivityListener((ClientModelRefreshJob)this.compareModel.getRefreshJob());
            }
        }
        if (this.compareViewer != null && IConversationContext.class.equals((Object)adapter)) {
            return this.compareViewer;
        }
        return super.getAdapter(adapter);
    }
}

