/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.ide.views;

import com.smartbear.ccollab.datamodel.client.ActionItemType;
import com.smartbear.ccollab.datamodel.client.IActionItem;
import com.smartbear.ccollab.datamodel.client.IClientActionItem;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.JsonAPIHandler;
import com.smartbear.collaborator.jobs.ClientModelRefreshJob;
import com.smartbear.collaborator.jobs.RefreshJob;
import com.smartbear.collaborator.ui.ActionItemsBlock;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.actions.ClientModelRefreshAction;
import com.smartbear.collaborator.ui.ide.CollaboratorIDEUI;
import com.smartbear.collaborator.ui.ide.jobs.ClientActionItemsRefreshJob;
import com.smartbear.collaborator.ui.util.PartAdapter2;
import com.smartbear.collaborator.ui.util.PlatformUIUtils;
import com.smartbear.jface.IOpenListener2;
import com.smartbear.util.SmartBearUtils;
import com.smartbear.util.URIUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.services.IServiceLocator;

public class ActionItemsView
extends ViewPart {
    public static final String ID = "com.smartbear.collaborator.ui.views.ActionItemsView";
    private ActionItemsBlock<IClientActionItem> block;
    private JobChangeAdapter refreshListener;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        site.getPage().addPartListener((IPartListener2)new PartAdapter2(){

            public void partVisible(IWorkbenchPartReference partRef) {
                if (ActionItemsView.ID.equals(partRef.getId())) {
                    ClientActionItemsRefreshJob.INSTANCE.start();
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        final ActionItemsBlock block = new ActionItemsBlock(parent);
        block.setLayoutData((Object)new GridData(4, 4, true, true));
        this.hookOpenAction((ActionItemsBlock<IClientActionItem>)block);
        ClientModelRefreshAction refreshAction = new ClientModelRefreshAction((ClientModelRefreshJob)ClientActionItemsRefreshJob.INSTANCE);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)refreshAction);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)refreshAction);
        this.getSite().setSelectionProvider(block.getSelectionProvider());
        this.block = block;
        final IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)this.getSite().getService(IWorkbenchSiteProgressService.class);
        this.refreshListener = new JobChangeAdapter(){
            private boolean busy = false;

            public void running(IJobChangeEvent event) {
                progressService.incrementBusy();
                this.busy = true;
            }

            public void done(IJobChangeEvent event) {
                final IStatus result = ((RefreshJob)event.getJob()).getLastResult();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        switch (result.getSeverity()) {
                            case 0: {
                                ActionItemsView.this.refresh(ClientActionItemsRefreshJob.INSTANCE.getActionItems());
                                break;
                            }
                            default: {
                                block.setError("An error happened and " + CollaboratorUI.PRODUCT_NAME + " could not get your Action Items.", result.getException());
                            }
                        }
                    }
                });
                if (this.busy) {
                    progressService.decrementBusy();
                    this.busy = false;
                }
            }
        };
        ClientActionItemsRefreshJob.INSTANCE.addJobChangeListener((IJobChangeListener)this.refreshListener);
        ClientActionItemsRefreshJob.INSTANCE.start();
    }

    private void hookOpenAction(ActionItemsBlock<IClientActionItem> block) {
        block.addOpenListener((IOpenListener2)new IOpenListener2<IClientActionItem>(){

            public void open(List<IClientActionItem> items) {
                IClientActionItem item = (IClientActionItem)SmartBearUtils.getFirstObject(items);
                Integer reviewId = item.getReviewId();
                if (null == reviewId) {
                    URL url = null;
                    try {
                        url = URIUtils.appendUrl((URL)Collaborator.getOptions().getUrl(), (String)item.getRelativeUrl());
                        if (url != null) {
                            CollaboratorIDEUI.openInBrowser(url);
                        }
                    }
                    catch (MalformedURLException e) {
                        CollaboratorUI.openError((Shell)CollaboratorUI.getShell(), (String)"Error open url", (Throwable)e, (boolean)true, (boolean)true);
                    }
                } else {
                    try {
                        PlatformUIUtils.executeCommand((IServiceLocator)ActionItemsView.this.getSite(), (String)"com.smartbear.collaborator.ui.commands.OpenReview", Collections.singletonMap("com.smartbear.collaborator.ui.commands.OpenReview_ReviewId", reviewId), Collections.emptyList());
                    }
                    catch (ExecutionException e) {
                        CollaboratorUI.openError((Shell)ActionItemsView.this.getSite().getShell(), (String)("Error opening Review '" + reviewId + "'"), (Throwable)e, (boolean)false, (boolean)true);
                    }
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        if (this.refreshListener != null) {
            ClientActionItemsRefreshJob.INSTANCE.removeJobChangeListener((IJobChangeListener)this.refreshListener);
        }
    }

    public void setFocus() {
        this.block.setFocus();
    }

    private void refresh(List<? extends IClientActionItem> actionItems) {
        if (!this.block.isDisposed()) {
            this.block.setActionItems(actionItems);
            this.setContentDescription(ActionItemsView.getSummary(actionItems));
        }
    }

    private static String getSummary(List<? extends IActionItem> actionItems) {
        int urgentCount = 0;
        for (IActionItem iActionItem : actionItems) {
            if (!JsonAPIHandler.isUserActionRequired((ActionItemType)iActionItem.getType())) continue;
            ++urgentCount;
        }
        return urgentCount + " Urgent out of " + actionItems.size() + " Action Items";
    }

    public static boolean isVisible() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window == null ? null : window.getActivePage();
        ActionItemsView view = page == null ? null : (ActionItemsView)page.findView(ID);
        return view != null && page.isPartVisible((IWorkbenchPart)view);
    }
}

