/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.ide.wizards;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.smartbear.beans.IScmOptions;
import com.smartbear.beans.ScmOptions;
import com.smartbear.ccollab.client.commands.CommandAddChanges;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.resources.ResourcesUtil;
import com.smartbear.collaborator.scm.IScmChangeAdapter;
import com.smartbear.collaborator.team.IResourceScmClientConfiguration;
import com.smartbear.collaborator.team.IResourceScmLocalCheckout;
import com.smartbear.collaborator.team.ResourceScmLocalCheckoutWrapper;
import com.smartbear.collaborator.team.scm.ScmChangeAdapter;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.changes.ChangedAndRevertedLabelDecorator;
import com.smartbear.collaborator.ui.ide.changes.ResourceContentProvider;
import com.smartbear.collaborator.ui.wizards.AbstractFileChangesSelectionPage;
import com.smartbear.collaborator.ui.wizards.IChangesSelectionPage;
import com.smartbear.progress.IteratorWithProgress;
import com.smartbear.scm.IScmLocalCheckout;
import com.smartbear.scm.impl.common.ScmRevertedLocalCheckout;
import com.smartbear.util.SmartBearUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class WorkspaceChangesSelectionPage
extends AbstractFileChangesSelectionPage<IResource, IContainer, IFile>
implements IChangesSelectionPage,
IAdapterFactory {
    private final IResourceScmClientConfiguration clientConfig;

    private WorkspaceChangesSelectionPage(IResourceScmClientConfiguration clientConfig, Iterable<IResource> initialSelectionsInOpenProjects) {
        super((Iterable)ResourcesUtil.getContainingProjects(initialSelectionsInOpenProjects), ResourcesUtil.filterContainers(initialSelectionsInOpenProjects), ResourcesUtil.filterFiles(initialSelectionsInOpenProjects), IFile.class);
        this.clientConfig = clientConfig;
    }

    public WorkspaceChangesSelectionPage(IResourceScmClientConfiguration clientConfig, List<IResource> initialSelections) {
        this(clientConfig, ResourcesUtil.filterInOpenProject(initialSelections));
    }

    public String getSuggestedNewReviewTitle() {
        ArrayList initialSelections = Lists.newArrayList((Iterable)Iterables.concat((Iterable)this.getInitialSelectionFiles(), (Iterable)this.getInitialSelectionFolders()));
        if (initialSelections.size() == 1) {
            IResource initialSelection = (IResource)SmartBearUtils.getFirstObject((Collection)initialSelections);
            return initialSelection.getName();
        }
        return null;
    }

    protected Map<IFile, IScmLocalCheckout> getModifiedFiles(IContainer root, IProgressMonitor monitor) throws ScmCommunicationException {
        IProject project = (IProject)root;
        HashMap<IFile, IScmLocalCheckout> modifiedFileToCheckout = new HashMap<IFile, IScmLocalCheckout>();
        List projectCheckouts = this.clientConfig.getModifiedFiles((IContainer)project, monitor);
        if (projectCheckouts == null) {
            throw new ScmCommunicationException("Could not get modified files for project " + project, null);
        }
        for (IResourceScmLocalCheckout checkout : projectCheckouts) {
            modifiedFileToCheckout.put(checkout.getLocalResource(), (IScmLocalCheckout)checkout);
        }
        return modifiedFileToCheckout;
    }

    protected boolean contains(IContainer container, IResource resource) {
        return container.getProject().equals(resource.getProject()) && container.getProjectRelativePath().isPrefixOf(resource.getProjectRelativePath());
    }

    protected ILabelProvider getLabelProvider(final ChangedAndRevertedLabelDecorator scmDecorator) {
        return new WorkbenchLabelProvider(){

            protected ImageDescriptor decorateImage(ImageDescriptor input, Object element) {
                return scmDecorator.decorateImage(input, element);
            }

            protected String decorateText(String input, Object element) {
                return scmDecorator.decorateText(input, element);
            }
        };
    }

    protected ViewerSorter getSorter() {
        return new ResourceSorter(1);
    }

    protected ITreeContentProvider getContentProvider(Collection<IFile> modifiedFiles) {
        return new ResourceContentProvider(modifiedFiles);
    }

    protected Map<IFile, IScmLocalCheckout> getRevertedFiles(IContainer root, Collection<IScmLocalCheckout> modifiedFiles, List<File> previouslyModifiedFiles, IProgressMonitor monitor) {
        IProject project = (IProject)root;
        if (project.getLocation() == null) {
            IScmLocalCheckout checkout = (IScmLocalCheckout)SmartBearUtils.getFirstObject(modifiedFiles);
            if (checkout != null) {
                CollaboratorUI.log((String)("ERROR - Could not calculate modified files for " + project + " with locationURI " + project.getLocationURI() + " and clientConfig " + checkout.getClientConfiguration().getDisplayableConfiguration()), null);
            }
            return Collections.emptyMap();
        }
        List revertedFiles = CommandAddChanges.getRevertedFiles((File)project.getLocation().toFile(), modifiedFiles, previouslyModifiedFiles);
        int projectPathSegments = project.getLocation().segmentCount();
        LinkedHashSet<IFile> revertedResources = new LinkedHashSet<IFile>(revertedFiles.size());
        for (File revertedFile : revertedFiles) {
            Path revertedPath = new Path(revertedFile.getAbsolutePath());
            IPath revertedRelativePath = revertedPath.removeFirstSegments(projectPathSegments);
            IFile revertedResource = project.getFile(revertedRelativePath);
            revertedResources.add(revertedResource);
        }
        HashMap<IFile, IScmLocalCheckout> revertedFileToCheckout = null;
        try {
            revertedFileToCheckout = new HashMap(revertedResources.size());
            IteratorWithProgress itr = IteratorWithProgress.getIterator(revertedResources, (String)"loading reverted files", (IProgressMonitor)monitor);
            while (itr.hasNext()) {
                IResourceScmLocalCheckout localCheckout = this.clientConfig.getLocalCheckout((IFile)itr.next(), itr.getIterationProgressMonitor());
                if (localCheckout == null) continue;
                IFile localResource = localCheckout.getLocalResource();
                ResourceScmLocalCheckoutWrapper revertedCheckout = new ResourceScmLocalCheckoutWrapper((IScmLocalCheckout)new ScmRevertedLocalCheckout((IScmLocalCheckout)localCheckout), localResource);
                revertedFileToCheckout.put(localResource, (IScmLocalCheckout)revertedCheckout);
            }
        }
        catch (ScmCommunicationException e) {
            CollaboratorUI.log((String)("Could not get reverted files in project " + project), (Throwable)e);
            revertedFileToCheckout = Collections.emptyMap();
        }
        return revertedFileToCheckout;
    }

    protected IScmChangeAdapter doGetSelectedChangesAdapter(Collection<? extends IScmLocalCheckout> modifiedAndRevertedCheckouts, Collection<? extends IResource> resources) {
        HashSet<IFile> filesOnly = new HashSet<IFile>();
        for (IResource iResource : resources) {
            if (iResource.getType() != 1) continue;
            filesOnly.add((IFile)iResource);
        }
        return new ScmChangeAdapter(modifiedAndRevertedCheckouts, filesOnly, this.clientConfig, (IScmOptions)new ScmOptions());
    }
}

