/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator;

import com.smartbear.ccollab.SimpleLargeContentStore;
import com.smartbear.ccollab.binary.ZoomScale;
import com.smartbear.ccollab.client.CollabClientServerConnectivityException;
import com.smartbear.ccollab.client.CollabServerSession;
import com.smartbear.ccollab.client.HttpClientResponseException;
import com.smartbear.ccollab.datamodel.ILargeObjectStore;
import com.smartbear.ccollab.datamodel.Product;
import com.smartbear.ccollab.datamodel.client.IVersion;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.IConnectionConfigListener;
import com.smartbear.collaborator.NotAllowedToAccessVersionContentException;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public class ClientContentManager {
    private volatile CollabServerSession session;
    private final ILargeObjectStore contentCache;
    public static String DATA_SERVLET_FORMAT = "data/server?versionid={0}&reviewid={1}";
    public static String DOCUMENT_PAGE_SERVLET_FORMAT = "document?r={0}&v={1}&p={2}&s={3}";

    private ClientContentManager(ILargeObjectStore contentCache) {
        this.contentCache = contentCache;
        Collaborator.addConnectionConfigListener(new IConnectionConfigListener(){

            @Override
            public void connectionConfigChanged() {
                ClientContentManager.this.session = null;
            }
        });
    }

    public boolean isCached(String md5) {
        try {
            return this.contentCache.exists(md5);
        }
        catch (IOException e) {
            Collaborator.log(e);
            return false;
        }
    }

    public IContentAccessor getContent(IVersion version, IProgressMonitor monitor) throws CollabClientServerConnectivityException, IOException, NotAllowedToAccessVersionContentException {
        return this.getContent(version.getReviewFile().getId(), version.getId(), version.getContentMd5(), monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContentAccessor getContent(int reviewId, int versionId, final String md5, IProgressMonitor monitor) throws CollabClientServerConnectivityException, IOException, NotAllowedToAccessVersionContentException {
        if (!this.contentCache.exists(md5)) {
            if (this.session == null) {
                try {
                    this.session = new CollabServerSession(Collaborator.getOptions(), Collaborator.getClientInterface());
                }
                catch (CollabClientException e) {
                    throw new CollabClientServerConnectivityException(CollabClientServerConnectivityException.ConnectionErrorType.NO_URL, "Fail to connect to server, " + e.getMessage());
                }
            }
            try (InputStream serverContent = null;){
                monitor.subTask("Connecting to " + Product.current.getProductName() + " Server");
                try {
                    serverContent = this.session.getPageAsStream(this.getContentUrl(reviewId, versionId));
                }
                catch (HttpClientResponseException e) {
                    if (e.isForbidden()) {
                        throw new NotAllowedToAccessVersionContentException(e.getForbiddenReason());
                    }
                    throw e;
                }
                monitor.subTask("Downloading content from " + Product.current.getProductName() + " Server");
                this.contentCache.save(md5, serverContent, monitor);
            }
        }
        return new IContentAccessor(){

            @Override
            public InputStream getContent() throws IOException {
                return ClientContentManager.this.contentCache.load(md5);
            }
        };
    }

    public IContentAccessor getPageContent(IVersion version, int page, ZoomScale scale, IProgressMonitor monitor) throws CollabClientServerConnectivityException, IOException, NotAllowedToAccessVersionContentException {
        return this.getPageContent(version.getReviewFile().getId(), version.getId(), version.getContentMd5(), page, scale, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContentAccessor getPageContent(int reviewId, int versionId, final String md5, int page, ZoomScale scale, IProgressMonitor monitor) throws CollabClientServerConnectivityException, IOException, NotAllowedToAccessVersionContentException {
        final String pageName = ClientContentManager.getPageName(page, scale);
        if (!this.contentCache.auxiliaryExists(md5, pageName)) {
            if (this.session == null) {
                try {
                    this.session = new CollabServerSession(Collaborator.getOptions(), Collaborator.getClientInterface());
                }
                catch (CollabClientException e) {
                    throw new CollabClientServerConnectivityException(CollabClientServerConnectivityException.ConnectionErrorType.NO_URL, "Fail to connect to server, " + e.getMessage());
                }
            }
            try (InputStream serverContent = null;){
                monitor.subTask("Connecting to " + Product.current.getProductName() + " Server");
                try {
                    serverContent = this.session.getPageAsStream(this.getPageContentUrl(reviewId, versionId, page, scale));
                }
                catch (HttpClientResponseException e) {
                    if (e.isForbidden()) {
                        throw new NotAllowedToAccessVersionContentException(e.getForbiddenReason());
                    }
                    throw e;
                }
                monitor.subTask("Downloading page content from " + Product.current.getProductName() + " Server");
                this.contentCache.saveAuxiliary(md5, pageName, serverContent, monitor);
            }
        }
        return new IContentAccessor(){

            @Override
            public InputStream getContent() throws IOException {
                return ClientContentManager.this.contentCache.loadAuxiliary(md5, pageName);
            }
        };
    }

    public ILargeObjectStore.IObjectSummary getCacheSummaryEstimate() throws IOException {
        return this.contentCache.getObjectSummaryEstimate();
    }

    public void clearCache(final IProgressMonitor monitor) throws IOException {
        int numObjects = this.contentCache.getObjectSummaryEstimate().getNumObjects();
        monitor.beginTask("Deleting cached file content", numObjects);
        this.contentCache.accept(new ILargeObjectStore.ILargeObjectVisitor(){

            public boolean visit(String md5) throws IOException {
                ClientContentManager.this.contentCache.delete(md5);
                monitor.worked(1);
                return true;
            }
        });
        monitor.done();
    }

    static final ClientContentManager create(File contentCacheDir) throws IOException {
        SimpleLargeContentStore contentCache = new SimpleLargeContentStore(contentCacheDir.getPath());
        contentCache.initialize();
        return new ClientContentManager((ILargeObjectStore)contentCache);
    }

    private String getContentUrl(int reviewId, int versionId) {
        return Strings.substitute((String)DATA_SERVLET_FORMAT, (String[])new String[]{Integer.toString(versionId), Integer.toString(reviewId)});
    }

    private String getPageContentUrl(int reviewId, int versionId, int page, ZoomScale scale) {
        return Strings.substitute((String)DOCUMENT_PAGE_SERVLET_FORMAT, (String[])new String[]{Integer.toString(reviewId), Integer.toString(versionId), Integer.toString(page), scale.getLabel()});
    }

    public static String getPageName(int pageNumber, ZoomScale scale) {
        if (scale == ZoomScale.ONEHUNDRED_PERCENT) {
            return "img-p" + pageNumber + ".png";
        }
        return "img-p" + pageNumber + "-" + scale.getLabel() + ".png";
    }

    public static enum NullContentAccessor implements IContentAccessor
    {
        INSTANCE;


        @Override
        public InputStream getContent() throws IOException {
            throw new IOException("Content not available");
        }
    }

    public static interface IContentAccessor {
        public InputStream getContent() throws IOException;
    }
}

