/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator;

import com.smartbear.CollabClientRuntimeException;
import com.smartbear.beans.ConfigUtils;
import com.smartbear.beans.GlobalOptions;
import com.smartbear.beans.IGlobalOptions;
import com.smartbear.beans.IScmOptions;
import com.smartbear.ccollab.client.CollabClientServerConnectivityException;
import com.smartbear.ccollab.client.ICollabClientInterface;
import com.smartbear.ccollab.client.LoginUtils;
import com.smartbear.ccollab.client.NullClient;
import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.datamodel.DataModelUtils;
import com.smartbear.ccollab.datamodel.Product;
import com.smartbear.ccollab.datamodel.client.IReviewSummary;
import com.smartbear.ccollab.datamodel.client.Phase;
import com.smartbear.collaborator.ClientContentManager;
import com.smartbear.collaborator.IConnectionConfigListener;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.json.interfaces.user.response.UserInfo;
import com.smartbear.collaborator.preferences.PrefsHelper;
import com.smartbear.collaborator.resourcebundlers.Messages;
import com.smartbear.util.CollabClientBrowserLaunchingException;
import com.smartbear.util.ListenerList;
import com.smartbear.util.commons.ArrayUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class Collaborator {
    public static String PRODUCT_NAME = Product.current.getProductName();
    public static final String ID = "com.smartbear.collaborator";
    private static ClientContentManager contentManager;
    private static final ListenerList<IConnectionConfigListener> CONFIG_LISTENERS;
    public static final Object JOB_FAMILY;
    private static final String CLIENT_INTERFACE_EXTENSION_POINT = "clientInterface";
    private static final String CLASS_ATTRIBUTE = "class";
    private static boolean debugging;

    private Collaborator() {
    }

    public static void log(String message, Throwable e) {
        Collaborator.log((IStatus)new Status(4, ID, 0, message, e));
    }

    public static void log(String message) {
        Collaborator.log(message, null);
    }

    public static void log(IStatus status) {
        Platform.getLog((Bundle)Platform.getBundle((String)ID)).log(status);
    }

    public static void log(Exception e) {
        String message = e.getLocalizedMessage();
        if (message == null || "".equals(message)) {
            message = Messages.getString("general.error.message", new Object[]{e.getClass().getName()});
        }
        Collaborator.log((IStatus)new Status(4, ID, 0, message, (Throwable)e));
    }

    public static ClientContentManager getContentManager() {
        if (contentManager == null) {
            File contentCacheDir = Platform.getStateLocation((Bundle)Platform.getBundle((String)ID)).append("content-cache").toFile();
            try {
                FileUtils.forceMkdir((File)contentCacheDir);
                contentManager = ClientContentManager.create(contentCacheDir);
            }
            catch (IOException e) {
                throw new RuntimeException("Plugin data area not writable", e);
            }
        }
        return contentManager;
    }

    public static void testClientConnection(PrefsHelper prefsHelper) throws CollabClientRuntimeException {
        try {
            IGlobalOptions options = Collaborator.getOptions(prefsHelper);
            LoginUtils.jsonLogin((IGlobalOptions)options, (ICollabClientInterface)Collaborator.getClientInterface());
        }
        catch (CollabClientException e) {
            throw new CollabClientRuntimeException(e.getMessage());
        }
    }

    public static UserInfo jsonLogin() throws CollabClientRuntimeException {
        try {
            UserInfo userInfo = LoginUtils.jsonLogin((IGlobalOptions)Collaborator.getOptions(), (ICollabClientInterface)Collaborator.getClientInterface());
            ConfigUtils.saveProductToken((String)Product.getFeatures().getToken());
            return userInfo;
        }
        catch (CollabClientException e) {
            throw new CollabClientRuntimeException(e.getMessage());
        }
    }

    public static void executeJson(Command command, UserInfo userInfo, IScmOptions scmOptions, IProgressMonitor monitor) throws CollabClientException {
        command.validateAndExecute(userInfo, Collaborator.getClientInterface(), Collaborator.getOptions(), scmOptions, monitor);
    }

    public static IGlobalOptions getOptions() throws CollabClientServerConnectivityException {
        return Collaborator.getOptions(PrefsHelper.getPrefs());
    }

    private static IGlobalOptions getOptions(PrefsHelper prefs) throws CollabClientServerConnectivityException {
        URL url = null;
        try {
            if (!StringUtils.isBlank((String)prefs.getUrl())) {
                url = new URL(prefs.getUrl());
            }
        }
        catch (MalformedURLException e) {
            throw new CollabClientServerConnectivityException(CollabClientServerConnectivityException.ConnectionErrorType.NO_URL, "Configured " + PRODUCT_NAME + " Server URL is not a valid URL: " + e.getMessage(), (Throwable)e);
        }
        GlobalOptions options = new GlobalOptions();
        options.setUrl(url);
        options.setServerProxyHost(prefs.getHttpProxy());
        options.setServerProxyPort(prefs.getHttpPort());
        options.setUser(prefs.getUser());
        options.setPassword(prefs.getPassword());
        options.setOverwriteTrustStoreInSsl(Boolean.valueOf(prefs.getOverwriteTrustStoreInSSL()));
        return options;
    }

    public static ICollabClientInterface getClientInterface() {
        Object[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(ID, CLIENT_INTERFACE_EXTENSION_POINT);
        if (ArrayUtils.isEmpty((Object[])configElements)) {
            return new NullClient();
        }
        Object configElement = configElements[0];
        if (configElements.length > 1) {
            String guessConfigElementId = Collaborator.isRunningIDE() ? "com.smartbear.collaborator.ui.ide.clientInterface" : "com.smartbear.collaborator.ui.standalone.clientInterface";
            Object[] guessConfigElements = Platform.getExtensionRegistry().getConfigurationElementsFor(ID, CLIENT_INTERFACE_EXTENSION_POINT, guessConfigElementId);
            if (!ArrayUtils.isEmpty((Object[])guessConfigElements)) {
                configElement = guessConfigElements[0];
            }
            if (Collaborator.isDebugging()) {
                System.out.println("Warning: More than one client interface registered!  Choosing: " + configElement.getDeclaringExtension().getLabel());
            }
        }
        try {
            return (ICollabClientInterface)configElements[0].createExecutableExtension(CLASS_ATTRIBUTE);
        }
        catch (CoreException e) {
            Collaborator.log("Could not load client interface from extension point", e);
            return new NullClient();
        }
    }

    public static boolean isConfigError(Throwable e) {
        return e instanceof CollabClientServerConnectivityException || ExceptionUtils.indexOfType((Throwable)e, CollabClientServerConnectivityException.class) != -1 || e instanceof CollabClientBrowserLaunchingException || ExceptionUtils.indexOfType((Throwable)e, CollabClientBrowserLaunchingException.class) != -1;
    }

    public static boolean isDebugging() {
        return debugging;
    }

    public static boolean isRunningIDE() {
        return ArrayUtils.contains((Object[])Platform.getCommandLineArgs(), (Object)"org.eclipse.ui.ide.workbench") || Platform.getProduct() != null && "org.eclipse.sdk.ide".equals(Platform.getProduct().getId());
    }

    public static void addConnectionConfigListener(IConnectionConfigListener listener) {
        CONFIG_LISTENERS.add((Object)listener);
    }

    public static void removeConnectionConfigListener(IConnectionConfigListener listener) {
        CONFIG_LISTENERS.remove((Object)listener);
    }

    public static void fireConnectionConfigChanged() {
        for (IConnectionConfigListener listener : CONFIG_LISTENERS.getListeners()) {
            listener.connectionConfigChanged();
        }
    }

    public static URL getUrl(IReviewSummary reviewSummary) {
        try {
            return new URL(DataModelUtils.getUrlToReviewFull((URL)new URL(PrefsHelper.getPrefs().getUrl()), (int)reviewSummary.getId(), (reviewSummary.getMovingOn().getPhase() == Phase.PLANNING ? 1 : 0) != 0));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        CONFIG_LISTENERS = new ListenerList();
        JOB_FAMILY = new Object();
        debugging = Boolean.valueOf(Platform.getDebugOption((String)"com.smartbear.collaborator/debug"));
    }
}

