/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator;

import com.smartbear.util.DebugLogFormatter;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class CommonsLoggingBridge
extends Jdk14Logger
implements Log {
    private static final String PLUGIN_ID = "com.smartbear.collaborator";
    private static final int DEBUG_SEVERITY = 2;
    private static final int INFO_SEVERITY = 1;
    private static final int ERROR_SEVERITY = 4;
    private static final int FATAL_SEVERITY = 4;
    private static final int WARN_SEVERITY = 2;
    private static final int TRACE_SEVERITY = 1;

    public CommonsLoggingBridge(String name) {
        super(name);
    }

    private void eclipseLog(int severity, String apacheCommonsSeverity, Object message, Throwable t) {
        String obscuredMessage;
        StringBuilder sb = new StringBuilder();
        sb.append(apacheCommonsSeverity).append(": ").append(new Date()).append(": ").append(this.name);
        if (message != null && StringUtils.isNotEmpty((String)(obscuredMessage = DebugLogFormatter.obscure((String)message.toString())))) {
            sb.append(SystemUtils.LINE_SEPARATOR).append(obscuredMessage);
        }
        FormattedStatus status = new FormattedStatus(severity, PLUGIN_ID, 0, sb.toString(), t);
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log((IStatus)status);
    }

    public void debug(Object message) {
        this.debug(message, null);
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.eclipseLog(2, "DEBUG", message, t);
        }
    }

    public void error(Object message) {
        this.error(message, null);
    }

    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.eclipseLog(4, "ERROR", message, t);
        }
    }

    public void fatal(Object message) {
        this.fatal(message, null);
    }

    public void fatal(Object message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.eclipseLog(4, "FATAL", message, t);
        }
    }

    public void info(Object message) {
        this.info(message, null);
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.eclipseLog(1, "INFO", message, t);
        }
    }

    public void trace(Object message) {
        this.trace(message, null);
    }

    public void trace(Object message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.eclipseLog(1, "TRACE", message, t);
        }
    }

    public void warn(Object message) {
        this.warn(message, null);
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.eclipseLog(2, "WARN", message, t);
        }
    }

    static {
        if (Boolean.valueOf(Platform.getDebugOption((String)"com.smartbear.collaborator/debug")).booleanValue()) {
            Logger.getLogger("").setLevel(Level.FINE);
        }
    }

    public static class FormattedStatus
    extends Status {
        public FormattedStatus(int severity, String pluginId, int code, String message, Throwable exception) {
            super(severity, pluginId, code, message, exception);
        }
    }
}

