/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.smartbear.ccollab.client.CollabClientServerConnectivityException;
import com.smartbear.ccollab.datamodel.Product;
import com.smartbear.ccollab.datamodel.client.ActionItemType;
import com.smartbear.ccollab.datamodel.client.ActivityType;
import com.smartbear.ccollab.datamodel.client.AssignmentState;
import com.smartbear.ccollab.datamodel.client.ChangeType;
import com.smartbear.ccollab.datamodel.client.CommentType;
import com.smartbear.ccollab.datamodel.client.CoordinateLocator;
import com.smartbear.ccollab.datamodel.client.DefectState;
import com.smartbear.ccollab.datamodel.client.DiffViewerDisplayMode;
import com.smartbear.ccollab.datamodel.client.FileSource;
import com.smartbear.ccollab.datamodel.client.FileType;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.IConversationProvider;
import com.smartbear.ccollab.datamodel.client.ILocator;
import com.smartbear.ccollab.datamodel.client.IRemoteSystem;
import com.smartbear.ccollab.datamodel.client.IReviewConversation;
import com.smartbear.ccollab.datamodel.client.IReviewFile;
import com.smartbear.ccollab.datamodel.client.IReviewGeneralInfo;
import com.smartbear.ccollab.datamodel.client.IReviewMovingOn;
import com.smartbear.ccollab.datamodel.client.IReviewSummary;
import com.smartbear.ccollab.datamodel.client.IReviewSummaryChange;
import com.smartbear.ccollab.datamodel.client.LabelLocator;
import com.smartbear.ccollab.datamodel.client.LineLocator;
import com.smartbear.ccollab.datamodel.client.LocatorType;
import com.smartbear.ccollab.datamodel.client.NoLicenseAvailableException;
import com.smartbear.ccollab.datamodel.client.OverallLocator;
import com.smartbear.ccollab.datamodel.client.PagedImageDiffZoomLevel;
import com.smartbear.ccollab.datamodel.client.Phase;
import com.smartbear.ccollab.datamodel.client.PublishState;
import com.smartbear.ccollab.datamodel.client.ReviewAccess;
import com.smartbear.ccollab.datamodel.client.ReviewAccessException;
import com.smartbear.ccollab.datamodel.client.ScmConsolidationMethod;
import com.smartbear.ccollab.datamodel.client.SignatureStatus;
import com.smartbear.ccollab.datamodel.client.UserThreadState;
import com.smartbear.ccollab.datamodel.client.VersionType;
import com.smartbear.ccollab.datamodel.client.impl.AbstractDMReviewConversation;
import com.smartbear.ccollab.datamodel.client.impl.AbstractDMReviewConversationProvider;
import com.smartbear.ccollab.datamodel.client.impl.AbstractDMVersionLocatable;
import com.smartbear.ccollab.datamodel.client.impl.DMActionItem;
import com.smartbear.ccollab.datamodel.client.impl.DMAutomaticLink;
import com.smartbear.ccollab.datamodel.client.impl.DMChecklistItem;
import com.smartbear.ccollab.datamodel.client.impl.DMClientActionItem;
import com.smartbear.ccollab.datamodel.client.impl.DMClientAtomicChangelist;
import com.smartbear.ccollab.datamodel.client.impl.DMClientFile;
import com.smartbear.ccollab.datamodel.client.impl.DMClientFileDefect;
import com.smartbear.ccollab.datamodel.client.impl.DMClientScmMaterials;
import com.smartbear.ccollab.datamodel.client.impl.DMClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.impl.DMContributor;
import com.smartbear.ccollab.datamodel.client.impl.DMCustomField;
import com.smartbear.ccollab.datamodel.client.impl.DMCustomFieldMultiSelection;
import com.smartbear.ccollab.datamodel.client.impl.DMCustomFieldSelection;
import com.smartbear.ccollab.datamodel.client.impl.DMCustomFieldString;
import com.smartbear.ccollab.datamodel.client.impl.DMCustomFieldStringBig;
import com.smartbear.ccollab.datamodel.client.impl.DMCustomFieldTreeSelection;
import com.smartbear.ccollab.datamodel.client.impl.DMCustomFieldType;
import com.smartbear.ccollab.datamodel.client.impl.DMDefect;
import com.smartbear.ccollab.datamodel.client.impl.DMDefectLogAccumulator;
import com.smartbear.ccollab.datamodel.client.impl.DMDefectLogEntry;
import com.smartbear.ccollab.datamodel.client.impl.DMFileChangeInformation;
import com.smartbear.ccollab.datamodel.client.impl.DMGroup;
import com.smartbear.ccollab.datamodel.client.impl.DMRemoteSystem;
import com.smartbear.ccollab.datamodel.client.impl.DMRemoteSystemItem;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewChecklist;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewComment;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewConversation;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewConversationSummary;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewFile;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewGeneralInfo;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewMovingOn;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewParticipant;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewSummary;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewSummaryChange;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewSummaryChangelist;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewSummaryFile;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewTemplate;
import com.smartbear.ccollab.datamodel.client.impl.DMRole;
import com.smartbear.ccollab.datamodel.client.impl.DMScm;
import com.smartbear.ccollab.datamodel.client.impl.DMScmMaterials;
import com.smartbear.ccollab.datamodel.client.impl.DMTemplateChecklist;
import com.smartbear.ccollab.datamodel.client.impl.DMUser;
import com.smartbear.ccollab.datamodel.client.impl.DMVersion;
import com.smartbear.ccollab.datamodel.client.impl.IUpdate;
import com.smartbear.ccollab.datamodel.client.listener.IConversationListener;
import com.smartbear.ccollab.datamodel.client.listener.IConversationProviderListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewConversationListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewFileListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewGeneralInfoListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewMovingOnListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewSummaryListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ConversationProviderAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewConversationAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewFileAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewGeneralInfoAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewMovingOnAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewSummaryAdapter;
import com.smartbear.ccollab.datamodel.client.listener.trace.TraceConversationListener;
import com.smartbear.ccollab.datamodel.client.listener.trace.TraceConversationProviderListener;
import com.smartbear.ccollab.datamodel.client.listener.trace.TraceReviewFileListener;
import com.smartbear.ccollab.datamodel.client.listener.trace.TraceReviewGeneralInfoListener;
import com.smartbear.ccollab.datamodel.client.listener.trace.TraceReviewMovingOnListener;
import com.smartbear.ccollab.datamodel.client.listener.trace.TraceReviewSummaryListener;
import com.smartbear.collaborator.JsonBatchCommand;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.json.api.CollaboratorJsonApi;
import com.smartbear.collaborator.json.interfaces.group.response.GroupDescription;
import com.smartbear.collaborator.json.interfaces.group.response.GroupListResponse;
import com.smartbear.collaborator.json.interfaces.remotesystem.ReviewRemoteSystemType;
import com.smartbear.collaborator.json.interfaces.review.AutomaticLink;
import com.smartbear.collaborator.json.interfaces.review.Contributor;
import com.smartbear.collaborator.json.interfaces.review.HasReviewId;
import com.smartbear.collaborator.json.interfaces.review.ReviewChecklist;
import com.smartbear.collaborator.json.interfaces.review.ReviewChecklistItem;
import com.smartbear.collaborator.json.interfaces.review.ReviewPhase;
import com.smartbear.collaborator.json.interfaces.review.TemplateChecklist;
import com.smartbear.collaborator.json.interfaces.review.conversation.CommentSummary;
import com.smartbear.collaborator.json.interfaces.review.conversation.Conversation;
import com.smartbear.collaborator.json.interfaces.review.conversation.DefectSummary;
import com.smartbear.collaborator.json.interfaces.review.conversation.Locator;
import com.smartbear.collaborator.json.interfaces.review.conversation.LocatorByVersion;
import com.smartbear.collaborator.json.interfaces.review.conversation.response.ConversationSummary;
import com.smartbear.collaborator.json.interfaces.review.materials.ReviewVersion;
import com.smartbear.collaborator.json.interfaces.review.materials.Version;
import com.smartbear.collaborator.json.interfaces.review.request.RemoteSystemLinkRequest;
import com.smartbear.collaborator.json.interfaces.review.request.ReviewChecklistRequest;
import com.smartbear.collaborator.json.interfaces.review.response.DefectLogEntry;
import com.smartbear.collaborator.json.interfaces.review.response.ParticipantState;
import com.smartbear.collaborator.json.interfaces.review.response.RemoteSystemsResponse;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewFile;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewGeneralInfo;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewMovingOn;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewParticipant;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewRemoteSystem;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewRemoteSystemItem;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewSummary;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewSummaryChange;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewSummaryChangelist;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewSummaryFile;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewTemplate;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewTemplateResponse;
import com.smartbear.collaborator.json.interfaces.review.response.ScmMaterials;
import com.smartbear.collaborator.json.interfaces.serverinfo.request.SystemGlobalValuesRequest;
import com.smartbear.collaborator.json.interfaces.serverinfo.response.SystemGlobalValuesResponse;
import com.smartbear.collaborator.json.interfaces.session.request.ClientBuildRequest;
import com.smartbear.collaborator.json.interfaces.systemadmin.CustomFieldModifyRole;
import com.smartbear.collaborator.json.interfaces.systemadmin.CustomFieldSettings;
import com.smartbear.collaborator.json.interfaces.systemadmin.CustomFieldSettingsTarget;
import com.smartbear.collaborator.json.interfaces.systemadmin.RoleSettings;
import com.smartbear.collaborator.json.interfaces.user.ActionItem;
import com.smartbear.collaborator.json.interfaces.user.ClientFileDefect;
import com.smartbear.collaborator.json.interfaces.user.request.ClientGuidRequest;
import com.smartbear.collaborator.json.interfaces.user.response.ClientActionItem;
import com.smartbear.collaborator.json.interfaces.user.response.ClientActionItemResponse;
import com.smartbear.collaborator.json.interfaces.user.response.ClientAtomicChangelist;
import com.smartbear.collaborator.json.interfaces.user.response.ClientFile;
import com.smartbear.collaborator.json.interfaces.user.response.ClientScmMaterials;
import com.smartbear.collaborator.json.interfaces.user.response.UserInfo;
import com.smartbear.collaborator.json.utils.JsonUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonAPIHandler {
    private static final Log LOG = LogFactory.getLog(JsonAPIHandler.class);
    private static final String ACTION_ADD = "add";
    private static final String ACTION_REMOVE = "remove";

    private static Date getDate(String dateString) throws ParseException {
        if (Strings.isNullOrEmpty((String)dateString)) {
            return null;
        }
        return JsonUtils.getDateFormat().parse(dateString);
    }

    public static void setChecklistItemStatus(int reviewId, Integer checklistItemId, boolean status) throws CollabClientException {
        ReviewChecklistItem request = (ReviewChecklistItem)JsonUtils.create(ReviewChecklistItem.class);
        request.setReviewId(Integer.valueOf(reviewId));
        request.setId(checklistItemId);
        request.setChecked(Boolean.valueOf(status));
        JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
        jsonBatchCommand.getCollaboratorJsonApi().reviewApi().checklistApi().setChecklistItemStatus(request);
    }

    public static void modifyRemoteSystems(int reviewId, Integer remoteSystemItemId, String action) throws CollabClientException {
        JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
        CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
        RemoteSystemLinkRequest request = (RemoteSystemLinkRequest)JsonUtils.create(RemoteSystemLinkRequest.class);
        request.setReviewId(Integer.valueOf(reviewId));
        request.setId(remoteSystemItemId);
        if ("Refresh".equalsIgnoreCase(action)) {
            jsonApi.reviewApi().remoteSystemLinksApi().refreshRemoteSystemLink(request);
        } else if ("Remove".equalsIgnoreCase(action)) {
            jsonApi.reviewApi().remoteSystemLinksApi().removeRemoteSystemLink(request);
        }
    }

    public static IClientSystemGlobals getClientSystemGlobals() throws CollabClientException {
        JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
        CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
        UserInfo userInfo = jsonApi.userApi().settingsApi().getSelfUser();
        DMUser.InitData initDataUser = new DMUser.InitData(userInfo.getId().intValue(), userInfo.getFullName());
        DMUser dmUser = new DMUser(initDataUser);
        SystemGlobalValuesRequest request = (SystemGlobalValuesRequest)JsonUtils.create(SystemGlobalValuesRequest.class);
        ArrayList<String> globals = new ArrayList<String>();
        globals.add("showGroupSelect");
        globals.add("bugCreateUrlTemplate");
        globals.add("defectLabelSingular");
        globals.add("defectsLabelPlural");
        globals.add("groupLabelSingular");
        request.setSystemGlobalValuesNames(globals);
        SystemGlobalValuesResponse response = jsonApi.userApi().getClientSystemGlobalValues(request);
        DMClientSystemGlobals.InitData initData = new DMClientSystemGlobals.InitData(new Boolean((String)response.getSystemGlobalValues().get("showGroupSelect")).booleanValue(), (String)response.getSystemGlobalValues().get("bugCreateUrlTemplate"), null, null, (String)response.getSystemGlobalValues().get("defectLabelSingular"), (String)response.getSystemGlobalValues().get("defectsLabelPlural"), (String)response.getSystemGlobalValues().get("groupLabelSingular"), null, 0, false, null, dmUser, null, null, null, false, null, null, null, null, null, null, null, null, null, null, null, false, 'N', null, null, false, PagedImageDiffZoomLevel.DEFAULT_ZOOM_LEVEL);
        DMClientSystemGlobals dmClientSystemGlobals = new DMClientSystemGlobals(initData);
        return dmClientSystemGlobals;
    }

    private static DMActionItem.InitData getDMActionItemInitData(ActionItem actionItem) {
        ActionItemType type = actionItem.getReviewNeedsCommit() != false ? ActionItemType.REVIEW_NEEDS_COMMIT : (actionItem.getRequiresUserAction() != false ? ActionItemType.REVIEW_IN_PROGRESS_RESPOND : ActionItemType.REVIEW_CANCELED);
        DMActionItem.InitData initdata = new DMActionItem.InitData(type, null, actionItem.getRelativeUrl(), actionItem.getReviewId(), actionItem.getReviewText(), actionItem.getNextActionText(), actionItem.getRoleText());
        return initdata;
    }

    public static List<DMActionItem> getActionItems() throws CollabClientException {
        JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
        List actionitems = jsonBatchCommand.getCollaboratorJsonApi().userApi().getActionItems();
        List dmActionItems = Lists.transform((List)actionitems, (Function)new Function<ActionItem, DMActionItem>(){

            public DMActionItem apply(ActionItem actionItem) {
                DMActionItem dmActionItem = new DMActionItem(JsonAPIHandler.getDMActionItemInitData(actionItem));
                return dmActionItem;
            }
        });
        return dmActionItems;
    }

    private static HashMap<Integer, DMClientFileDefect> getDMClientFileDefect(List<ClientFileDefect> clientFileDefects) {
        HashMap dmClientFileDefects = Maps.newHashMapWithExpectedSize((int)clientFileDefects.size());
        for (ClientFileDefect clientFileDefect : clientFileDefects) {
            DefectState state = DefectState.OPEN;
            if (DefectState.OPEN.getName().equalsIgnoreCase(clientFileDefect.getState())) {
                state = DefectState.OPEN;
            }
            if (DefectState.FIXED.getName().equalsIgnoreCase(clientFileDefect.getState())) {
                state = DefectState.FIXED;
            }
            if (DefectState.EXTERNAL.getName().equalsIgnoreCase(clientFileDefect.getState())) {
                state = DefectState.EXTERNAL;
            }
            DMClientFileDefect dmClientFileDefect = new DMClientFileDefect(clientFileDefect.getDefectId().intValue(), clientFileDefect.getOriginVersionId().intValue(), clientFileDefect.getOriginVersionContentMD5(), JsonAPIHandler.getLocator(clientFileDefect.getOriginLocator()), clientFileDefect.getText(), state);
            dmClientFileDefects.put(clientFileDefect.getDefectId(), dmClientFileDefect);
        }
        return dmClientFileDefects;
    }

    private static HashMap<String, DMClientFile> getDMClientFiles(List<ClientFile> clientFiles) {
        HashMap dmClientFiles = Maps.newHashMapWithExpectedSize((int)clientFiles.size());
        int index = 0;
        for (ClientFile clientFile : clientFiles) {
            List clientFileDefects = clientFile.getDefects();
            DMClientFile dmClientFile = new DMClientFile(clientFile.getLocalFile(), JsonAPIHandler.getDMClientFileDefect(clientFile.getDefects()));
            dmClientFiles.put("ClientFile" + index++, dmClientFile);
        }
        return dmClientFiles;
    }

    private static HashMap<String, DMClientAtomicChangelist> getDMClientAtomicChangelist(List<ClientAtomicChangelist> clientAtomicChangelists) {
        HashMap dmClientAtomicChangelists = Maps.newHashMapWithExpectedSize((int)clientAtomicChangelists.size());
        int index = 0;
        for (ClientAtomicChangelist clientAtomicChangelist : clientAtomicChangelists) {
            DMClientAtomicChangelist dmClientAtomicChangelist = new DMClientAtomicChangelist(clientAtomicChangelist.getScmId(), JsonAPIHandler.getDMClientFiles(clientAtomicChangelist.getClientFiles()));
            dmClientAtomicChangelists.put("ClientAtomicChangelist" + index++, dmClientAtomicChangelist);
        }
        return dmClientAtomicChangelists;
    }

    public static List<DMClientActionItem> getClientActionItems(String clientGuid) throws CollabClientException {
        JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
        CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
        ClientGuidRequest request = (ClientGuidRequest)JsonUtils.create(ClientGuidRequest.class);
        request.setClientGuid(clientGuid);
        ClientActionItemResponse response = jsonApi.userApi().getClientActionItems(request);
        List clientActionItems = response.getClientActionItems();
        ArrayList dmClientActionItems = Lists.newArrayListWithCapacity((int)clientActionItems.size());
        for (ClientActionItem clientActionItem : clientActionItems) {
            DMActionItem.InitData superInitData = JsonAPIHandler.getDMActionItemInitData((ActionItem)clientActionItem);
            List clientScmMaterials = clientActionItem.getClientScmMaterials();
            HashMap scmMaterials = Maps.newHashMapWithExpectedSize((int)clientScmMaterials.size());
            int index = 0;
            for (ClientScmMaterials clientScmMaterial : clientScmMaterials) {
                DMClientScmMaterials dmClientScmMaterials = new DMClientScmMaterials(clientScmMaterial.getToken(), null, null, JsonAPIHandler.getDMClientFiles(clientScmMaterial.getClientFiles()), JsonAPIHandler.getDMClientAtomicChangelist(clientScmMaterial.getClientAtomicChangelists()));
                scmMaterials.put("SCMMaterials" + index++, dmClientScmMaterials);
            }
            DMClientActionItem dmClientActionItem = new DMClientActionItem(superInitData, scmMaterials);
            dmClientActionItem.initAfterDeserialize();
            dmClientActionItems.add(dmClientActionItem);
        }
        return dmClientActionItems;
    }

    public static boolean isUserActionRequired(ActionItemType type) {
        return type == ActionItemType.REVIEW_NEEDS_COMMIT || type == ActionItemType.REVIEW_IN_PROGRESS_RESPOND;
    }

    public static ArrayList<DMUser> getDMUsers(List<UserInfo> userInfos) {
        if (userInfos == null) {
            return new ArrayList<DMUser>();
        }
        List dmUsers = Lists.transform(userInfos, (Function)new Function<UserInfo, DMUser>(){

            public DMUser apply(UserInfo userInfo) {
                DMUser.InitData initData = new DMUser.InitData(userInfo.getId().intValue(), userInfo.getFullName());
                DMUser dmUser = new DMUser(initData);
                return dmUser;
            }
        });
        return new ArrayList<DMUser>(dmUsers);
    }

    private static ArrayList<DMRole> getDMRoles(List<RoleSettings> roleSettings) {
        ArrayList dmRoles = Lists.newArrayListWithCapacity((int)roleSettings.size());
        for (RoleSettings roleSetting : roleSettings) {
            DMRole dmRole = new DMRole(roleSetting.getId().intValue(), roleSetting.getSystemName(), roleSetting.getName(), roleSetting.getDescription(), roleSetting.getMinimumRequiredInReview().intValue(), roleSetting.getMaximumAllowedInReview().intValue(), roleSetting.isRequiredToSign().booleanValue());
            dmRoles.add(dmRole);
        }
        return dmRoles;
    }

    public static Phase fromReviewPhase(ReviewPhase reviewPhase) {
        if (reviewPhase == null) {
            return null;
        }
        return Phase.valueOf((String)reviewPhase.name());
    }

    private static com.smartbear.ccollab.datamodel.client.CustomFieldModifyRole fromCustomFieldModifyRole(CustomFieldModifyRole modifyRole) {
        if (modifyRole == null) {
            return null;
        }
        switch (modifyRole) {
            case ANY: {
                return com.smartbear.ccollab.datamodel.client.CustomFieldModifyRole.ANY;
            }
            case ASSIGNED: {
                return com.smartbear.ccollab.datamodel.client.CustomFieldModifyRole.ASSIGNED;
            }
            case AUTHOR: {
                return com.smartbear.ccollab.datamodel.client.CustomFieldModifyRole.AUTHOR;
            }
            case MODERATOR: {
                return com.smartbear.ccollab.datamodel.client.CustomFieldModifyRole.MODERATOR;
            }
            case AUTHOR_MODERATOR: {
                return com.smartbear.ccollab.datamodel.client.CustomFieldModifyRole.AUTHOR_MODERATOR;
            }
            case AUTHOR_ASSIGNED: {
                return com.smartbear.ccollab.datamodel.client.CustomFieldModifyRole.AUTHOR_ASSIGNED;
            }
            case MODERATOR_ASSIGNED: {
                return com.smartbear.ccollab.datamodel.client.CustomFieldModifyRole.MODERATOR_ASSIGNED;
            }
        }
        return null;
    }

    private static DMCustomField.InitData getCommonInitData(CustomFieldSettings customFieldSettings) {
        List reviewVisiblePhases = customFieldSettings.getVisiblePhases();
        List reviewMandatoryPhases = customFieldSettings.getMandatoryPhases();
        HashSet<Phase> visiblePhases = new HashSet<Phase>(reviewVisiblePhases.size());
        for (Object reviewPhase : reviewVisiblePhases) {
            Phase phase = JsonAPIHandler.fromReviewPhase((ReviewPhase)reviewPhase);
            visiblePhases.add(phase);
        }
        HashSet<Phase> mandatoryPhases = new HashSet<Phase>(reviewMandatoryPhases.size());
        for (ReviewPhase reviewPhase : reviewMandatoryPhases) {
            Phase phase = JsonAPIHandler.fromReviewPhase(reviewPhase);
            mandatoryPhases.add(phase);
        }
        DMCustomField.InitData initData = new DMCustomField.InitData(DMCustomFieldType.valueOf((String)customFieldSettings.getCustomFieldType().name()), customFieldSettings.getTitle(), customFieldSettings.getDescription(), visiblePhases, null, mandatoryPhases, customFieldSettings.isAnyPhaseMandatory(), customFieldSettings.isAllowInspectionReworkMoving(), JsonAPIHandler.fromCustomFieldModifyRole(customFieldSettings.getCustomFieldModifyRole()));
        return initData;
    }

    private static ArrayList<DMCustomField> getDMCustomFields(List<CustomFieldSettings> listOfCustomFieldSettings) {
        ArrayList dmCustomFields = Lists.newArrayListWithCapacity((int)listOfCustomFieldSettings.size());
        for (CustomFieldSettings customFieldSettings : listOfCustomFieldSettings) {
            DMCustomField.InitData initData = JsonAPIHandler.getCommonInitData(customFieldSettings);
            switch (customFieldSettings.getCustomFieldType()) {
                case MULTI_SELECTION: {
                    DMCustomFieldMultiSelection dmCustomFieldMultiSelection = new DMCustomFieldMultiSelection(initData, customFieldSettings.getItems());
                    dmCustomFields.add(dmCustomFieldMultiSelection);
                    break;
                }
                case SELECTION: {
                    DMCustomFieldSelection dmCustomFieldSelection = new DMCustomFieldSelection(initData, customFieldSettings.getDefaultValue(), customFieldSettings.getItems());
                    dmCustomFields.add(dmCustomFieldSelection);
                    break;
                }
                case STRING: {
                    String validatorString = customFieldSettings.getValidator();
                    Pattern validator = StringUtils.isNotBlank((String)validatorString) ? Pattern.compile(validatorString) : null;
                    DMCustomFieldString dmCustomFieldString = new DMCustomFieldString(initData, customFieldSettings.getDefaultValue(), customFieldSettings.getMinimumLength().intValue(), customFieldSettings.getMaximumLength().intValue(), validator);
                    dmCustomFields.add(dmCustomFieldString);
                    break;
                }
                case STRINGBIG: {
                    DMCustomFieldStringBig dmCustomFieldStringBig = new DMCustomFieldStringBig(initData, customFieldSettings.getDefaultValue(), customFieldSettings.getMinimumLength().intValue(), customFieldSettings.getMaximumLength().intValue());
                    dmCustomFields.add(dmCustomFieldStringBig);
                    break;
                }
                case TREE_SELECTION: {
                    DMCustomFieldTreeSelection dmCustomFieldTreeSelection = new DMCustomFieldTreeSelection(initData, customFieldSettings.getDefaultValue(), customFieldSettings.getItems(), null);
                    dmCustomFields.add(dmCustomFieldTreeSelection);
                    break;
                }
            }
        }
        return dmCustomFields;
    }

    private static ArrayList<DMAutomaticLink> getDMAutomaticLinks(List<AutomaticLink> automaticLinks) {
        ArrayList dmAutomaticLinks = Lists.newArrayListWithCapacity((int)automaticLinks.size());
        for (AutomaticLink automaticLink : automaticLinks) {
            DMAutomaticLink dmAutomaticLink = new DMAutomaticLink(automaticLink.getRegex(), automaticLink.getTitle(), automaticLink.getTooltip(), automaticLink.getUrlFormat(), automaticLink.getCaseSensitive().booleanValue());
            dmAutomaticLinks.add(dmAutomaticLink);
        }
        return dmAutomaticLinks;
    }

    private static DMReviewTemplate getReviewTemplate(ReviewTemplate reviewTemplate) {
        if (reviewTemplate == null) {
            return null;
        }
        return new DMReviewTemplate(reviewTemplate.getId().intValue(), reviewTemplate.getName(), reviewTemplate.getDescription(), reviewTemplate.getUsedByDefault().booleanValue(), JsonAPIHandler.getDMRoles(reviewTemplate.getRoles()), JsonAPIHandler.getDMCustomFields(reviewTemplate.getReviewCustomFields()), null, JsonAPIHandler.getDMCustomFields(reviewTemplate.getParticipantCustomFields()), JsonAPIHandler.getDMCustomFields(reviewTemplate.getDefectCustomFields()), JsonAPIHandler.getDMAutomaticLinks(reviewTemplate.getAutomaticLinks()), reviewTemplate.getActive().booleanValue(), reviewTemplate.getRemoteSystemLinksEnabled().booleanValue(), reviewTemplate.isCommentsDuringReworkEnabled().booleanValue(), reviewTemplate.isCommentsAfterDeadlineEnabled().booleanValue(), reviewTemplate.isReopenReviewIfCommentAdded().booleanValue(), reviewTemplate.isAllowToAssignDefects().booleanValue(), reviewTemplate.isRemoveHeadersAndFooters().booleanValue(), reviewTemplate.isOverrideGlobalReviewDeadline().booleanValue(), reviewTemplate.getReviewDeadlineDays().intValue(), reviewTemplate.isOverrideGlobalEnableEditableComments().booleanValue(), reviewTemplate.isEnableEditableComments().booleanValue(), reviewTemplate.isOverrideGlobalReviewAccessRestriction().booleanValue(), reviewTemplate.getReviewAccessRestriction());
    }

    public static List<DMGroup> getGroups(int reviewId) throws CollabClientException {
        JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
        CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
        HasReviewId request = (HasReviewId)JsonUtils.create(HasReviewId.class);
        request.setReviewId(Integer.valueOf(reviewId));
        GroupListResponse response = jsonApi.reviewApi().summaryApi().getGroupList(request);
        List groups = response.getGroupList();
        ArrayList dmGroups = Lists.newArrayListWithCapacity((int)groups.size());
        for (GroupDescription group : groups) {
            DMGroup dmGroup = JsonAPIHandler.getDMGroup(group);
            dmGroups.add(dmGroup);
        }
        return dmGroups;
    }

    private static Map<Integer, List<DMCustomField>> getDMChecklistCustomFields(Map<Integer, List<CustomFieldSettings>> map) {
        return map.entrySet().stream().collect(Collectors.toMap(entry -> (Integer)entry.getKey(), entry -> JsonAPIHandler.getDMCustomFields((List)entry.getValue())));
    }

    private static Map<Integer, DMTemplateChecklist> getDMTemplateChecklists(List<TemplateChecklist> reviewChecklists) {
        return reviewChecklists.stream().collect(Collectors.toMap(reviewChecklist -> reviewChecklist.getId(), reviewChecklist -> new DMTemplateChecklist(reviewChecklist.getId(), reviewChecklist.getTitle(), Boolean.TRUE.equals(reviewChecklist.isEnabled()))));
    }

    public static List<DMReviewTemplate> getReviewTemplates() throws CollabClientException {
        JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
        CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
        ClientBuildRequest request = (ClientBuildRequest)JsonUtils.create(ClientBuildRequest.class);
        request.setClientBuild(Integer.valueOf(Product.current.getProductBuild()));
        ReviewTemplateResponse response = jsonApi.reviewApi().summaryApi().getReviewTemplates(request);
        List reviewTemplates = response.getReviewTemplates();
        ArrayList dmReviewTemplates = Lists.newArrayListWithCapacity((int)reviewTemplates.size());
        for (ReviewTemplate reviewTemplate : reviewTemplates) {
            DMReviewTemplate dmTemplate = JsonAPIHandler.getReviewTemplate(reviewTemplate);
            dmReviewTemplates.add(dmTemplate);
        }
        return dmReviewTemplates;
    }

    private static DMContributor getDMContributor(Contributor contributor) {
        if (contributor == null) {
            return null;
        }
        DMUser.InitData initDataUser = new DMUser.InitData(contributor.getId().intValue(), contributor.getFullName());
        DMContributor.InitData initdata = new DMContributor.InitData(initDataUser, contributor.getInitials());
        DMContributor dmContributor = new DMContributor(initdata);
        return dmContributor;
    }

    private static ArrayList<DMContributor> getDMContributors(List<Contributor> contributors) {
        if (contributors == null) {
            return null;
        }
        ArrayList dmContributors = Lists.newArrayListWithCapacity((int)contributors.size());
        for (Contributor contributor : contributors) {
            DMContributor dmContributor = JsonAPIHandler.getDMContributor(contributor);
            dmContributors.add(dmContributor);
        }
        return dmContributors;
    }

    private static HashMap<String, HashSet<String>> getCustomFieldValues(List<CustomFieldSettingsTarget> customFieldSettingsTargets) {
        HashMap<String, HashSet<String>> customFieldValues = new HashMap<String, HashSet<String>>(customFieldSettingsTargets.size());
        for (CustomFieldSettingsTarget customFieldSettingsTarget : customFieldSettingsTargets) {
            String key = customFieldSettingsTarget.getCustomFieldTitle();
            HashSet values = new HashSet(customFieldSettingsTarget.getCustomFieldValue());
            customFieldValues.put(key, values);
        }
        return customFieldValues;
    }

    private static DMDefect getDMDefect(DefectSummary defectSummary) throws ParseException {
        if (defectSummary == null) {
            return null;
        }
        AbstractDMVersionLocatable.InitData superInitData = new AbstractDMVersionLocatable.InitData(defectSummary.getCreatorId(), JsonAPIHandler.getDate(defectSummary.getCreationDate()), "", "", "");
        return new DMDefect(superInitData, defectSummary.getDefectId(), defectSummary.getText(), DefectState.valueOf((String)defectSummary.getState()), null, defectSummary.getExternalName(), defectSummary.getWhyNotAllowedToFix(), defectSummary.getWhyNotAllowedToReject(), defectSummary.getWhyNotAllowedToModify(), defectSummary.getWhyNotAllowedToDelete(), defectSummary.isOutdated(), JsonAPIHandler.getCustomFieldValues(defectSummary.getCustomFieldValue()), null);
    }

    private static HashMap<Integer, DMDefect> getDMDefects(List<DefectSummary> defectSummarys) throws ParseException {
        if (defectSummarys == null) {
            return null;
        }
        HashMap<Integer, DMDefect> defects = new HashMap<Integer, DMDefect>(defectSummarys.size());
        for (DefectSummary defectSummary : defectSummarys) {
            Integer key = defectSummary.getDefectId();
            DMDefect dmDefect = JsonAPIHandler.getDMDefect(defectSummary);
            defects.put(key, dmDefect);
        }
        return defects;
    }

    private static DMReviewComment getDMComment(CommentSummary commentSummary) throws ParseException {
        if (commentSummary == null) {
            return null;
        }
        AbstractDMVersionLocatable.InitData superInitData = new AbstractDMVersionLocatable.InitData(commentSummary.getCreatorId(), JsonAPIHandler.getDate(commentSummary.getCreationDate()), "", "", "");
        int id = commentSummary.getCommentId();
        String text = commentSummary.getText();
        CommentType type = CommentType.valueOf((String)commentSummary.getType());
        return new DMReviewComment(superInitData, id, text, type, PublishState.valueOf((String)commentSummary.getPublishState()), commentSummary.getMarkedRead(), commentSummary.getWhyNotAllowedToRedact(), commentSummary.isOutdated(), null, null);
    }

    private static HashMap<Integer, DMReviewComment> getComments(List<CommentSummary> commentSummarys) throws ParseException {
        if (commentSummarys == null) {
            return null;
        }
        HashMap<Integer, DMReviewComment> comments = new HashMap<Integer, DMReviewComment>(commentSummarys.size());
        for (CommentSummary commentSummary : commentSummarys) {
            Integer key = commentSummary.getCommentId();
            DMReviewComment dmComment = JsonAPIHandler.getDMComment(commentSummary);
            comments.put(key, dmComment);
        }
        return comments;
    }

    private static DMVersion getDMVersion(Version version) throws ParseException {
        if (version == null) {
            return null;
        }
        return new DMVersion(version.getMd5(), version.getId(), version.getScmVersionName(), version.getComment(), JsonAPIHandler.getDate(version.getDate()), version.getAuthor(), version.getPath(), version.getLocalPath(), version.getName(), FileType.valueOf((String)version.getFileType()), ChangeType.valueOf((String)version.getChangeType()), FileSource.valueOf((String)version.getSource().name()), version.getTitle(), null, version.getNumPages(), VersionType.valueOf((String)version.getVersionType()), null, false);
    }

    private static HashMap<Integer, DMVersion> getDMVersions(List<Version> versions) throws ParseException {
        if (versions == null) {
            return null;
        }
        HashMap<Integer, DMVersion> dmVersions = new HashMap<Integer, DMVersion>(versions.size());
        for (Version version : versions) {
            Integer key = version.getId();
            DMVersion dmVersion = JsonAPIHandler.getDMVersion(version);
            dmVersions.put(key, dmVersion);
        }
        return dmVersions;
    }

    private static ILocator getLocator(Locator locator) {
        if (locator == null) {
            return OverallLocator.INSTANCE;
        }
        LocatorType locatorType = LocatorType.valueOf((String)locator.getType());
        switch (locatorType) {
            case OVERALL: {
                return OverallLocator.INSTANCE;
            }
            case LABEL: {
                return new LabelLocator(locator.getLabel());
            }
            case LINE: {
                return new LineLocator(locator.getLineNumber().intValue());
            }
            case COORDINATE: {
                return new CoordinateLocator(locator.getPage().intValue(), locator.getX().intValue(), locator.getY().intValue(), locator.getPinNumber().intValue());
            }
        }
        return OverallLocator.INSTANCE;
    }

    private static DMReviewConversation getDMConversation(Conversation conversation) throws ParseException {
        if (conversation == null) {
            return null;
        }
        AbstractDMReviewConversation.InitData superInitData = new AbstractDMReviewConversation.InitData(conversation.getOriginVersionId(), JsonAPIHandler.getLocator(conversation.getOriginLocator()));
        List locatorByVersions = conversation.getLocators();
        HashMap<Integer, ILocator> locators = new HashMap<Integer, ILocator>(locatorByVersions.size());
        for (LocatorByVersion locatorByVersion : locatorByVersions) {
            Integer key = locatorByVersion.getVersionId();
            ILocator iLocator = JsonAPIHandler.getLocator(locatorByVersion.getLocator());
            locators.put(key, iLocator);
        }
        HashMap<Integer, DMReviewComment> comments = JsonAPIHandler.getComments(conversation.getComments());
        HashMap<Integer, DMDefect> defects = JsonAPIHandler.getDMDefects(conversation.getDefects());
        return new DMReviewConversation(superInitData, comments, defects, locators, conversation.getOriginVersionContentMD5(), UserThreadState.valueOf((String)conversation.getUserThreadState()), conversation.getWhyNotAllowedToAccept(), conversation.getConversationId(), "");
    }

    private static ArrayList<DMReviewConversation> getDMConversations(List<Conversation> conversations) throws ParseException {
        if (conversations == null) {
            return null;
        }
        ArrayList dmConversations = Lists.newArrayListWithCapacity((int)conversations.size());
        for (Conversation conversation : conversations) {
            DMReviewConversation dmConversation = JsonAPIHandler.getDMConversation(conversation);
            dmConversations.add(dmConversation);
        }
        return dmConversations;
    }

    private static DMGroup getDMGroup(GroupDescription group) {
        if (group == null) {
            return null;
        }
        DMGroup.InitData initData = new DMGroup.InitData(group.getGuid(), group.getTitle(), group.getDescription(), group.isAllowAssociateWithReviews().booleanValue(), group.isReviewPool().booleanValue(), group.isEnabled().booleanValue(), false);
        DMGroup dmGroup = new DMGroup(initData);
        return dmGroup;
    }

    private static DMReviewGeneralInfo getDMReviewGeneralInfo(ReviewGeneralInfo reviewGeneralInfo) throws ParseException {
        if (reviewGeneralInfo == null) {
            return null;
        }
        return new DMReviewGeneralInfo(reviewGeneralInfo.getTitle(), null, JsonAPIHandler.getReviewTemplate(reviewGeneralInfo.getReviewTemplate()), JsonAPIHandler.getDMGroup(reviewGeneralInfo.getGroup()), null, null, JsonAPIHandler.getDate(reviewGeneralInfo.getCreationDate()), "", "", JsonAPIHandler.getDate(reviewGeneralInfo.getCompletionDate()), "", "", reviewGeneralInfo.getWhyNotAllowedToCancel(), "", reviewGeneralInfo.getWhyNotAllowedToModify(), reviewGeneralInfo.getWhyNotAllowedToModifyReview(), reviewGeneralInfo.getWhyNotAllowedToModifyChecklist(), reviewGeneralInfo.getWhyNotAllowedToModifyChecklistItem(), reviewGeneralInfo.getWhyNotAllowedToModifyParticipants(), reviewGeneralInfo.getWhyNotAllowedToModifyRemoteSystemLinks(), reviewGeneralInfo.getWhyNotAllowedToAddReviewPoolParticipant(), reviewGeneralInfo.getWhyNotAllowedToReopen(), reviewGeneralInfo.getWhyNotAllowedToReject(), "", reviewGeneralInfo.getRejectReason(), false, false, ReviewAccess.valueOf((String)reviewGeneralInfo.getReviewAccess()), JsonAPIHandler.getCustomFieldValues(reviewGeneralInfo.getCustomFieldValue()), 1, false, null);
    }

    private static DMReviewParticipant getDMReviewParticipant(ReviewParticipant reviewParticipants) {
        if (reviewParticipants == null) {
            return null;
        }
        return new DMReviewParticipant(reviewParticipants.getUser().getId(), JsonAPIHandler.getDMGroup(reviewParticipants.getPoolGroup()), reviewParticipants.getRole().getId(), AssignmentState.valueOf((String)reviewParticipants.getAssignmentState()), "", "", reviewParticipants.getWhyNotAllowedToPoke(), "", "", "", "", "", JsonAPIHandler.getCustomFieldValues(reviewParticipants.getCustomFieldValue()), SignatureStatus.valueOf((String)reviewParticipants.getSignatureStatus()), "");
    }

    private static DMChecklistItem getDMReviewChecklistItem(ReviewChecklistItem reviewChecklistItem) throws ParseException {
        if (reviewChecklistItem == null) {
            return null;
        }
        int userId = 0;
        UserInfo userInfo = reviewChecklistItem.getUserInfo();
        if (userInfo != null && userInfo.getId() != null) {
            userId = userInfo.getId();
        }
        DMChecklistItem dmChecklistItem = new DMChecklistItem(reviewChecklistItem.getId(), reviewChecklistItem.getTitle(), reviewChecklistItem.isChecked(), JsonAPIHandler.getDate(reviewChecklistItem.getDateModified()), "", userId, JsonAPIHandler.getCustomFieldValues(reviewChecklistItem.getCustomFieldValue()));
        return dmChecklistItem;
    }

    private static Map<Integer, DMChecklistItem> getDMReviewChecklistItems(List<ReviewChecklistItem> checklistItems) throws ParseException {
        HashMap<Integer, DMChecklistItem> dmReviewChecklistItems = new HashMap<Integer, DMChecklistItem>();
        for (ReviewChecklistItem reviewChecklistItem : checklistItems) {
            dmReviewChecklistItems.put(reviewChecklistItem.getId(), JsonAPIHandler.getDMReviewChecklistItem(reviewChecklistItem));
        }
        return dmReviewChecklistItems;
    }

    private static DMReviewChecklist getDMReviewChecklist(ReviewChecklist reviewChecklist) throws ParseException {
        if (reviewChecklist == null) {
            return null;
        }
        DMReviewChecklist dmReviewChecklist = new DMReviewChecklist(reviewChecklist.getId(), reviewChecklist.getTitle(), Boolean.TRUE.equals(reviewChecklist.isMandatory()), JsonAPIHandler.getDMReviewChecklistItems(reviewChecklist.getChecklistItems()), JsonAPIHandler.getDMCustomFields(reviewChecklist.getChecklistCustomFields()));
        return dmReviewChecklist;
    }

    private static DMRemoteSystemItem getDMReviewRemoteSystemItem(ReviewRemoteSystemItem remoteSystemItem) throws ParseException {
        if (remoteSystemItem == null) {
            return null;
        }
        DMRemoteSystem dmRemoteSystem = null;
        ReviewRemoteSystem reviewRemoteSystem = remoteSystemItem.getRemoteSystem();
        if (reviewRemoteSystem != null) {
            ReviewRemoteSystemType remoteSystemType = reviewRemoteSystem.getType();
            dmRemoteSystem = new DMRemoteSystem(reviewRemoteSystem.getId().intValue(), reviewRemoteSystem.getTitle(), remoteSystemType.name());
        }
        DMRemoteSystemItem dmRemoteSystemItem = new DMRemoteSystemItem(remoteSystemItem.getId(), remoteSystemItem.getTitle(), remoteSystemItem.getUrl(), remoteSystemItem.getStatus(), (IRemoteSystem)dmRemoteSystem, Boolean.valueOf(true), remoteSystemItem.getRemoteReviewId());
        return dmRemoteSystemItem;
    }

    private static Map<Integer, DMReviewChecklist> getReviewChecklists(List<ReviewChecklist> reviewChecklists) throws ParseException {
        if (reviewChecklists == null) {
            return null;
        }
        HashMap<Integer, DMReviewChecklist> dmReviewChecklists = new HashMap<Integer, DMReviewChecklist>(reviewChecklists.size());
        for (ReviewChecklist reviewChecklist : reviewChecklists) {
            Integer key = reviewChecklist.getId();
            DMReviewChecklist dmReviewChecklist = JsonAPIHandler.getDMReviewChecklist(reviewChecklist);
            dmReviewChecklists.put(key, dmReviewChecklist);
        }
        return dmReviewChecklists;
    }

    private static HashMap<Integer, DMRemoteSystemItem> getReviewRemoteSystemItems(List<ReviewRemoteSystemItem> remoteSystemItems) throws ParseException {
        if (remoteSystemItems == null) {
            return null;
        }
        HashMap<Integer, DMRemoteSystemItem> dmRemoteSystemItems = new HashMap<Integer, DMRemoteSystemItem>(remoteSystemItems.size());
        for (ReviewRemoteSystemItem remoteSystemItem : remoteSystemItems) {
            Integer key = remoteSystemItem.getId();
            DMRemoteSystemItem dmReviewRemoteSystemItem = JsonAPIHandler.getDMReviewRemoteSystemItem(remoteSystemItem);
            dmRemoteSystemItems.put(key, dmReviewRemoteSystemItem);
        }
        return dmRemoteSystemItems;
    }

    private static DMDefectLogEntry getDMDefectLogEntry(DefectLogEntry defectLogEntry) throws ParseException {
        if (defectLogEntry == null) {
            return null;
        }
        DMDefectLogEntry dmDefectLogEntry = new DMDefectLogEntry(JsonAPIHandler.getDMDefect(defectLogEntry.getDefectSummary()), JsonAPIHandler.getLocator(defectLogEntry.getLocator()), defectLogEntry.getFileVersionId(), JsonAPIHandler.getLocator(defectLogEntry.getLocator()), defectLogEntry.getOriginalFileVersionId(), defectLogEntry.getFilePath());
        return dmDefectLogEntry;
    }

    private static DMDefectLogAccumulator getDMDefectLogEntrys(List<DefectLogEntry> defectLogEntrys) throws ParseException {
        if (defectLogEntrys == null) {
            return null;
        }
        HashMap<Integer, DMDefectLogEntry> dmDefectLogEntrys = new HashMap<Integer, DMDefectLogEntry>(defectLogEntrys.size());
        for (DefectLogEntry defectLogEntry : defectLogEntrys) {
            Integer key = defectLogEntry.getDefectSummary().getDefectId();
            DMDefectLogEntry dmDefectLogEntry = JsonAPIHandler.getDMDefectLogEntry(defectLogEntry);
            dmDefectLogEntrys.put(key, dmDefectLogEntry);
        }
        return new DMDefectLogAccumulator(dmDefectLogEntrys);
    }

    private static HashMap<Integer, DMReviewParticipant> getDMReviewParticipants(List<ReviewParticipant> reviewParticipants) {
        if (reviewParticipants == null) {
            return null;
        }
        HashMap<Integer, DMReviewParticipant> dmReviewParticipants = new HashMap<Integer, DMReviewParticipant>(reviewParticipants.size());
        for (ReviewParticipant reviewParticipant : reviewParticipants) {
            Integer key = reviewParticipant.getUser().getId();
            DMReviewParticipant dmReviewParticipant = JsonAPIHandler.getDMReviewParticipant(reviewParticipant);
            dmReviewParticipants.put(key, dmReviewParticipant);
        }
        return dmReviewParticipants;
    }

    private static HashMap<Integer, UserThreadState> getStates(List<ParticipantState> participantStates) {
        if (participantStates == null) {
            return null;
        }
        HashMap<Integer, UserThreadState> states = new HashMap<Integer, UserThreadState>(participantStates.size());
        for (ParticipantState participantState : participantStates) {
            Integer key = participantState.getReviewParticipantId();
            UserThreadState state = UserThreadState.valueOf((String)participantState.getState());
            states.put(key, state);
        }
        return states;
    }

    private static DMReviewConversationSummary getDMConversationSummary(ConversationSummary conversationSummary) {
        AbstractDMReviewConversation.InitData superInitData = new AbstractDMReviewConversation.InitData(conversationSummary.getOriginVersionId(), JsonAPIHandler.getLocator(conversationSummary.getOriginLocator()));
        return new DMReviewConversationSummary(superInitData, JsonAPIHandler.getLocator(conversationSummary.getLocator()), conversationSummary.isUnread().booleanValue(), conversationSummary.getContainsUserComment().booleanValue(), false, 0, UserThreadState.valueOf((String)conversationSummary.getState()), JsonAPIHandler.getStates(conversationSummary.getParticipantStates()), conversationSummary.getFirstEntryId().intValue());
    }

    private static ArrayList<DMReviewConversationSummary> getDMConversationSummarys(List<ConversationSummary> conversationSummarys) {
        if (conversationSummarys == null) {
            return null;
        }
        ArrayList dmConversationSummarys = Lists.newArrayListWithCapacity((int)conversationSummarys.size());
        for (ConversationSummary conversationSummary : conversationSummarys) {
            DMReviewConversationSummary dmConversationSummary = JsonAPIHandler.getDMConversationSummary(conversationSummary);
            dmConversationSummarys.add(dmConversationSummary);
        }
        return dmConversationSummarys;
    }

    private static DMReviewSummaryFile getReviewSummaryFile(ReviewSummaryFile reviewSummaryFile) {
        if (reviewSummaryFile == null) {
            return null;
        }
        return new DMReviewSummaryFile(reviewSummaryFile.getLatestVersionId().intValue(), reviewSummaryFile.getPath(), reviewSummaryFile.getLocalFilePath(), ChangeType.valueOf((String)reviewSummaryFile.getChangeType()), FileSource.valueOf((String)reviewSummaryFile.getFileSource()), reviewSummaryFile.getLinesAdded(), reviewSummaryFile.getLinesModified(), reviewSummaryFile.getLinesDeleted(), reviewSummaryFile.getStatusText(), reviewSummaryFile.getNumReworks().intValue(), reviewSummaryFile.getAnnotation(), JsonAPIHandler.getDMConversationSummarys(reviewSummaryFile.getConversationSummarys()));
    }

    private static DMReviewSummaryChange getReviewSummaryChange(ReviewSummaryChange reviewSummaryChange) {
        if (reviewSummaryChange == null) {
            return null;
        }
        return new DMReviewSummaryChange(reviewSummaryChange.getId(), reviewSummaryChange.getAuthor(), reviewSummaryChange.getHash(), reviewSummaryChange.getDate(), "", reviewSummaryChange.getComment(), reviewSummaryChange.getStatus(), reviewSummaryChange.isVisible().booleanValue());
    }

    private static List<DMReviewSummaryFile> getFiles(List<ReviewSummaryFile> reviewSummaryFiles) {
        if (reviewSummaryFiles == null) {
            return null;
        }
        ArrayList files = Lists.newArrayListWithCapacity((int)reviewSummaryFiles.size());
        for (ReviewSummaryFile reviewSummaryFile : reviewSummaryFiles) {
            files.add(JsonAPIHandler.getReviewSummaryFile(reviewSummaryFile));
        }
        return files;
    }

    private static List<IReviewSummaryChange> getChanges(List<ReviewSummaryChange> reviewSummaryChanges) {
        if (reviewSummaryChanges == null) {
            return null;
        }
        ArrayList changes = Lists.newArrayListWithCapacity((int)reviewSummaryChanges.size());
        for (ReviewSummaryChange change : reviewSummaryChanges) {
            changes.add(JsonAPIHandler.getReviewSummaryChange(change));
        }
        return changes;
    }

    private static DMReviewSummaryChangelist getReviewSummaryChangelist(ReviewSummaryChangelist reviewSummaryChangelist) throws ParseException {
        if (reviewSummaryChangelist == null) {
            return null;
        }
        DMReviewSummaryChangelist.InitData initData = new DMReviewSummaryChangelist.InitData(reviewSummaryChangelist.getScmId(), reviewSummaryChangelist.getName(), reviewSummaryChangelist.getAuthors(), JsonAPIHandler.getDate(reviewSummaryChangelist.getDate()), "", reviewSummaryChangelist.getDescription(), JsonAPIHandler.getChanges(reviewSummaryChangelist.getChanges()));
        List<DMReviewSummaryFile> files = JsonAPIHandler.getFiles(reviewSummaryChangelist.getReviewSummaryFiles());
        return new DMReviewSummaryChangelist(initData, files);
    }

    private static HashMap<Integer, DMReviewSummaryChangelist> getDMReviewSummaryChangelists(List<ReviewSummaryChangelist> reviewSummaryChangelists) throws ParseException {
        if (reviewSummaryChangelists == null) {
            return null;
        }
        HashMap<Integer, DMReviewSummaryChangelist> dmReviewsummaryChangeLists = new HashMap<Integer, DMReviewSummaryChangelist>(reviewSummaryChangelists.size());
        for (ReviewSummaryChangelist reviewSummaryChangelist : reviewSummaryChangelists) {
            Integer key = reviewSummaryChangelist.getChanglistId();
            DMReviewSummaryChangelist dmReviewSummaryChangelist = JsonAPIHandler.getReviewSummaryChangelist(reviewSummaryChangelist);
            dmReviewsummaryChangeLists.put(key, dmReviewSummaryChangelist);
        }
        return dmReviewsummaryChangeLists;
    }

    private static DMScm.InitData getDMScmInitData(String token, String displayName) {
        DMScm.InitData initData = new DMScm.InitData(token, displayName, null, null);
        return initData;
    }

    private static DMScmMaterials getDMScmMaterials(ScmMaterials scmMaterials) throws ParseException {
        if (scmMaterials == null) {
            return null;
        }
        DMScm.InitData superInitData = JsonAPIHandler.getDMScmInitData(scmMaterials.getToken(), scmMaterials.getDisplayName());
        return new DMScmMaterials(superInitData, ScmConsolidationMethod.valueOf((String)scmMaterials.getDefaultConsolidationMethod()), JsonAPIHandler.getDMReviewSummaryChangelists(scmMaterials.getReviewSummaryChangelists()), Sets.newHashSet((Iterable)scmMaterials.getConsolidatedChangelistIds()), JsonAPIHandler.getReviewSummaryChangelist(scmMaterials.getConsolidatedChangelist()));
    }

    private static HashMap<String, DMScmMaterials> getDMScmMaterials(List<ScmMaterials> scmMaterials) throws ParseException {
        if (scmMaterials == null) {
            return null;
        }
        HashMap<String, DMScmMaterials> dmScmMaterials = new HashMap<String, DMScmMaterials>(scmMaterials.size());
        for (ScmMaterials scmMaterial : scmMaterials) {
            String key = scmMaterial.getId();
            DMScmMaterials dmScmMaterial = JsonAPIHandler.getDMScmMaterials(scmMaterial);
            dmScmMaterials.put(key, dmScmMaterial);
        }
        return dmScmMaterials;
    }

    private static HashMap<ActivityType, String> getNotAllowedStrings(Map<String, String> notAllowedStrings) {
        if (notAllowedStrings == null) {
            return null;
        }
        HashMap<ActivityType, String> strings = new HashMap<ActivityType, String>(notAllowedStrings.size());
        for (String notAllowedString : notAllowedStrings.keySet()) {
            ActivityType activityType = ActivityType.valueOf((String)notAllowedString);
            String value = notAllowedStrings.get(notAllowedString);
            strings.put(activityType, value);
        }
        return strings;
    }

    private static DMReviewMovingOn getDMReviewMovingOn(ReviewMovingOn reviewMovingOn) {
        if (reviewMovingOn == null) {
            return null;
        }
        return new DMReviewMovingOn(reviewMovingOn.getExplanation(), Phase.valueOf((String)reviewMovingOn.getPhase().name()), JsonAPIHandler.getNotAllowedStrings(reviewMovingOn.getWhyNotAllowedToWait()), JsonAPIHandler.getNotAllowedStrings(reviewMovingOn.getWhyNotAllowedToFinish()), reviewMovingOn.getWhyNotAllowedToAnnotate(), reviewMovingOn.isAuthorRole().booleanValue(), reviewMovingOn.getAuthorRoleName(), reviewMovingOn.isNeedsSignatures().booleanValue(), SignatureStatus.valueOf((String)reviewMovingOn.getSignatureStatus()), null);
    }

    private static DMReviewSummary getReviewSummary(int reviewId, Map<String, ScmConsolidationMethod> consolidationMethods, String updateToken, boolean active) throws CollabClientException, ParseException {
        JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
        CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
        ReviewSummary response = jsonApi.reviewApi().summaryApi().getReviewSummary(reviewId, updateToken, active);
        AbstractDMReviewConversationProvider.InitData superInitData = new AbstractDMReviewConversationProvider.InitData(response.getReviewId().intValue(), response.getRefreshInterval(), JsonAPIHandler.getDMContributors(response.getContributors()), response.getWhyNotAllowedToCreateComment(), response.getWhyNotAllowedToCreateDefect(), response.getWhyNotAllowedToMarkRead(), response.getWhyNotAllowedToUploadContent());
        DMReviewSummary.InitData initdata = new DMReviewSummary.InitData(superInitData, updateToken, response.getName(), response.isCommitTodo().booleanValue(), JsonAPIHandler.getDMReviewGeneralInfo(response.getGeneralInfo()), JsonAPIHandler.getDMReviewParticipants(response.getReviewParticipants()), JsonAPIHandler.getDMDefectLogEntrys(response.getDefectLogEntrys()), JsonAPIHandler.getDMConversation(response.getOverallConversation()), JsonAPIHandler.getDMScmMaterials(response.getScmMaterials()), JsonAPIHandler.getDMReviewMovingOn(response.getReviewMovingOn()), JsonAPIHandler.getDMTemplateChecklists(response.getTemplateChecklists()), JsonAPIHandler.getReviewChecklists(response.getReviewChecklists()), JsonAPIHandler.getReviewRemoteSystemItems(response.getRemoteSystemItems()), response.getOpenDefects().booleanValue(), false, null, false);
        DMReviewSummary dmReviewSummary = new DMReviewSummary(initdata);
        dmReviewSummary.initAfterDeserialize();
        return dmReviewSummary;
    }

    public static DMReviewSummary getReviewSummary(int reviewId) throws CollabClientException, ParseException {
        DMReviewSummary dmReviewSummary = JsonAPIHandler.getReviewSummary(reviewId, Collections.emptyMap(), null, true);
        if (LOG.isDebugEnabled()) {
            TraceReviewSummaryListener reviewSummaryListener = new TraceReviewSummaryListener();
            dmReviewSummary.addReviewSummaryListener((IReviewSummaryListener)reviewSummaryListener);
            ReviewSummaryAdapter.init((IReviewSummary)dmReviewSummary, (IReviewSummaryListener)reviewSummaryListener);
            TraceConversationProviderListener convoProviderListener = new TraceConversationProviderListener();
            dmReviewSummary.addConversationProviderListener((IConversationProviderListener)convoProviderListener);
            ConversationProviderAdapter.init((IConversationProvider)dmReviewSummary, (IConversationProviderListener)convoProviderListener);
            TraceReviewGeneralInfoListener generalInfoListener = new TraceReviewGeneralInfoListener();
            dmReviewSummary.getGeneralInfo().addReviewGeneralInfoListener((IReviewGeneralInfoListener)generalInfoListener);
            ReviewGeneralInfoAdapter.init((IReviewGeneralInfo)dmReviewSummary.getGeneralInfo(), (IReviewGeneralInfoListener)generalInfoListener);
            TraceConversationListener convoListener = new TraceConversationListener();
            dmReviewSummary.getOverallConversation().addConversationListener((IConversationListener)convoListener);
            ReviewConversationAdapter.init((IReviewConversation)dmReviewSummary.getOverallConversation(), (IReviewConversationListener)((IReviewConversationListener)convoListener));
            TraceReviewMovingOnListener movingOnListener = new TraceReviewMovingOnListener();
            dmReviewSummary.getMovingOn().addMovingOnListener((IReviewMovingOnListener)movingOnListener);
            ReviewMovingOnAdapter.init((IReviewMovingOn)dmReviewSummary.getMovingOn(), (IReviewMovingOnListener)movingOnListener);
            LOG.debug((Object)(dmReviewSummary + " event trace listeners initialized"));
        }
        return dmReviewSummary;
    }

    private static HashMap<String, Integer> getReviewPathVersionIds(List<ReviewVersion> reviewVersions) {
        if (reviewVersions == null) {
            return null;
        }
        HashMap<String, Integer> reviewPathVersionIds = new HashMap<String, Integer>(reviewVersions.size());
        for (ReviewVersion reviewVersion : reviewVersions) {
            String key = reviewVersion.getLocalPath();
            Integer value = reviewVersion.getId();
            reviewPathVersionIds.put(key, value);
        }
        return reviewPathVersionIds;
    }

    private static DMReviewFile getReviewFile(int reviewId, int versionId, String updateToken, boolean active) throws CollabClientException, ParseException {
        JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
        CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
        ReviewFile response = jsonApi.reviewApi().reviewMaterialsApi().getReviewFile(reviewId, versionId, updateToken, active);
        AbstractDMReviewConversationProvider.InitData superInitData = new AbstractDMReviewConversationProvider.InitData(response.getReviewId().intValue(), response.getRefreshInterval(), JsonAPIHandler.getDMContributors(response.getContributors()), response.getWhyNotAllowedToCreateComment(), response.getWhyNotAllowedToCreateDefect(), response.getWhyNotAllowedToMarkRead(), response.getWhyNotAllowedToUploadContent());
        DMScm.InitData dmScmInitData = JsonAPIHandler.getDMScmInitData(response.getScm().getToken(), response.getScm().getDisplayName());
        DMScm scm = new DMScm(dmScmInitData);
        DMFileChangeInformation fileChangeInformation = new DMFileChangeInformation();
        ArrayList<String> columnValues = new ArrayList<String>();
        columnValues.add("eclipse_default_data");
        fileChangeInformation.addItem(columnValues, response.getDefaultVersionId().intValue(), response.getDefaultPrevVersionId().intValue(), ChangeType.MODIFIED, false, false, DiffViewerDisplayMode.COMMITS);
        fileChangeInformation.setDefaultItemIndex(Integer.valueOf(fileChangeInformation.getItemsCount() - 1));
        DMReviewFile.InitData initData = new DMReviewFile.InitData(superInitData, Integer.valueOf(versionId), updateToken, JsonAPIHandler.getDMConversation(response.getOverallConversation()), JsonAPIHandler.getDMConversations(response.getConversations()), JsonAPIHandler.getDMVersions(response.getVersions()), JsonAPIHandler.getDMVersions(response.getUpstreamVersions()), JsonAPIHandler.getReviewPathVersionIds(response.getReviewPathVersionIds()), JsonAPIHandler.getDMAutomaticLinks(response.getAutomaticLinks()), JsonAPIHandler.getDMCustomFields(response.getDefectCustomFields()), scm, ChangeType.valueOf((String)response.getChangeType()), fileChangeInformation, null, null, null, false, false, false);
        DMReviewFile dmReviewFile = new DMReviewFile(initData);
        dmReviewFile.initAfterDeserialize();
        if (LOG.isDebugEnabled()) {
            TraceReviewFileListener reviewFileListener = new TraceReviewFileListener();
            dmReviewFile.addReviewFileListener((IReviewFileListener)reviewFileListener);
            ReviewFileAdapter.init((IReviewFile)dmReviewFile, (IReviewFileListener)reviewFileListener);
            TraceConversationProviderListener convoProviderListener = new TraceConversationProviderListener();
            dmReviewFile.addConversationProviderListener((IConversationProviderListener)convoProviderListener);
            ConversationProviderAdapter.init((IConversationProvider)dmReviewFile, (IConversationProviderListener)convoProviderListener);
            LOG.debug((Object)(dmReviewFile + " event trace listeners initialized"));
        }
        return dmReviewFile;
    }

    public static DMReviewFile getReviewFile(int reviewId, int versionId) throws CollabClientException, ParseException {
        DMReviewFile dmReviewFile = JsonAPIHandler.getReviewFile(reviewId, versionId, null, true);
        if (LOG.isDebugEnabled()) {
            TraceReviewFileListener reviewFileListener = new TraceReviewFileListener();
            dmReviewFile.addReviewFileListener((IReviewFileListener)reviewFileListener);
            ReviewFileAdapter.init((IReviewFile)dmReviewFile, (IReviewFileListener)reviewFileListener);
            TraceConversationProviderListener convoProviderListener = new TraceConversationProviderListener();
            dmReviewFile.addConversationProviderListener((IConversationProviderListener)convoProviderListener);
            ConversationProviderAdapter.init((IConversationProvider)dmReviewFile, (IConversationProviderListener)convoProviderListener);
            LOG.debug((Object)(dmReviewFile + " event trace listeners initialized"));
        }
        return dmReviewFile;
    }

    public static void updateReviewFile(final DMReviewFile currentState, Executor updateExecutor, boolean active) throws ReviewAccessException, CollabClientServerConnectivityException, NoLicenseAvailableException, CollabClientException, ParseException {
        int reviewId = currentState.getId();
        int versionId = ((DMVersion)currentState.getVersions().get(0)).getId();
        String updateToken = currentState.getUpdateToken();
        final DMReviewFile delta = JsonAPIHandler.getReviewFile(reviewId, versionId, updateToken, active);
        updateExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ArrayList updates = currentState.updateFrom(delta);
                for (IUpdate update : updates) {
                    update.run();
                }
            }
        });
    }

    public static void updateReviewSummary(final DMReviewSummary currentState, Map<String, ScmConsolidationMethod> consolidationMethods, Executor updateExecutor, boolean active) throws ReviewAccessException, CollabClientServerConnectivityException, NoLicenseAvailableException, CollabClientException, ParseException {
        int reviewId = currentState.getId();
        String updateToken = currentState.getUpdateToken();
        final DMReviewSummary delta = JsonAPIHandler.getReviewSummary(reviewId, consolidationMethods, updateToken, active);
        updateExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ArrayList updates = currentState.updateFrom(delta);
                for (IUpdate update : updates) {
                    update.run();
                }
            }
        });
    }

    public static List<DMRemoteSystem> getRemoteSystems() throws CollabClientException, ParseException {
        JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
        CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
        RemoteSystemsResponse remoteSystemResponse = jsonApi.systemAdminApi().remoteSystemIntegrationApi().getRemoteSystems();
        List remoteSystems = remoteSystemResponse.getRemoteSystems();
        ArrayList<DMRemoteSystem> dmRemoteSystems = new ArrayList<DMRemoteSystem>(remoteSystems.size());
        for (ReviewRemoteSystem remoteSystem : remoteSystems) {
            DMRemoteSystem dmRemoteSystem = new DMRemoteSystem(remoteSystem.getId().intValue(), remoteSystem.getTitle(), "");
            dmRemoteSystems.add(dmRemoteSystem);
        }
        return dmRemoteSystems;
    }

    public static void addRemoteSystemLink(int reviewId, Integer remoteSystemId, String reference) throws CollabClientException {
        JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
        CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
        RemoteSystemLinkRequest request = (RemoteSystemLinkRequest)JsonUtils.create(RemoteSystemLinkRequest.class);
        request.setReviewId(Integer.valueOf(reviewId));
        request.setRemoteSystemId(remoteSystemId);
        request.setRef(reference);
        jsonApi.reviewApi().remoteSystemLinksApi().addRemoteSystemLink(request);
    }

    private static void processChecklist(int reviewId, Integer checklistId, String action) throws CollabClientException {
        JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
        CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
        ReviewChecklistRequest request = (ReviewChecklistRequest)JsonUtils.create(ReviewChecklistRequest.class);
        request.setReviewId(Integer.valueOf(reviewId));
        request.setChecklistId(checklistId);
        if (ACTION_ADD.equalsIgnoreCase(action)) {
            jsonApi.reviewApi().checklistApi().addChecklist(request);
        } else if (ACTION_REMOVE.equalsIgnoreCase(action)) {
            jsonApi.reviewApi().checklistApi().removeChecklist(request);
        }
    }

    public static void addReviewChecklist(int reviewId, Integer checklistId) throws CollabClientException {
        JsonAPIHandler.processChecklist(reviewId, checklistId, ACTION_ADD);
    }

    public static void removeReviewChecklist(int reviewId, Integer checklistId) throws CollabClientException {
        JsonAPIHandler.processChecklist(reviewId, checklistId, ACTION_REMOVE);
    }
}

