/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.jobs;

import com.smartbear.ccollab.client.CollabClientServerConnectivityException;
import com.smartbear.ccollab.datamodel.client.IActionItem;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.jobs.ClientModelRefreshJob;
import com.smartbear.collaborator.preferences.PrefsHelper;
import com.smartbear.util.SmartBearUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class AbstractActionItemsRefreshJob<I extends IActionItem>
extends ClientModelRefreshJob {
    private static final Object ACTION_ITEMS_REFRESH_JOB_FAMILY = new Object();
    private List<I> actionItems = Collections.emptyList();

    protected AbstractActionItemsRefreshJob() {
        super("Action Items");
    }

    @Override
    protected long getRefreshIntervalMillis() {
        long actionRefreshMins = PrefsHelper.getPrefs().getActionRefresh();
        actionRefreshMins = Math.max(1L, actionRefreshMins);
        return actionRefreshMins * 60000L;
    }

    @Override
    protected IStatus doRun(IProgressMonitor monitor) throws CollabClientServerConnectivityException {
        this.actionItems = this.loadActionItems();
        return Status.OK_STATUS;
    }

    protected abstract List<I> loadActionItems() throws CollabClientServerConnectivityException;

    public List<I> getActionItems() {
        return this.actionItems;
    }

    @Override
    public boolean belongsTo(Object family) {
        return ACTION_ITEMS_REFRESH_JOB_FAMILY == family || super.belongsTo(family);
    }

    public static void refreshActionItems() {
        ClientModelRefreshJob job;
        Object[] jobs = Job.getJobManager().find(ACTION_ITEMS_REFRESH_JOB_FAMILY);
        if (jobs.length > 1) {
            Collaborator.log("More than 1 action items job found: " + Arrays.asList(jobs));
        }
        if ((job = (ClientModelRefreshJob)((Object)SmartBearUtils.getFirstObject((Object[])jobs))) != null) {
            job.start();
        }
    }
}

