/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.jobs;

import com.google.common.base.Strings;
import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.client.commands.admin.review.AbstractReviewCommand;
import com.smartbear.ccollab.datamodel.Scm;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.JsonBatchCommand;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.json.api.CollaboratorJsonApi;
import com.smartbear.collaborator.json.interfaces.review.materials.ChangelistDescriptor;
import com.smartbear.collaborator.json.interfaces.review.materials.request.AddFilesRequest;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewInfo;
import com.smartbear.collaborator.json.interfaces.user.response.UserInfo;
import com.smartbear.collaborator.json.utils.JsonUtils;
import com.smartbear.collaborator.resourcebundlers.Messages;
import com.smartbear.collaborator.scm.IScmChangeAdapter;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.IScmConnectionParameters;
import com.smartbear.scm.IScmLocalCheckout;
import com.smartbear.scm.IScmSystem;
import com.smartbear.scm.ScmChangeset;
import com.smartbear.scm.ScmUtils;
import com.smartbear.util.PathUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;

public abstract class AddToReviewJob
extends Job {
    private UserInfo currentUserInfo;
    IScmChangeAdapter changes;
    List<File> supportingDocuments;
    private ReviewInfo reviewInfo;

    public AddToReviewJob(UserInfo currentUserInfo, String name, IScmChangeAdapter changes, List<File> supportingDocuments) {
        super(name);
        this.currentUserInfo = currentUserInfo;
        this.setUser(true);
        this.changes = changes;
        this.supportingDocuments = supportingDocuments;
    }

    public UserInfo getCurrentUserInfo() {
        return this.currentUserInfo;
    }

    public boolean belongsTo(Object family) {
        return family == Collaborator.JOB_FAMILY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        Object returnStatus;
        try {
            NullProgressMonitor supportingDocumentsMonitor;
            SubProgressMonitor changesMonitor;
            monitor.beginTask(Messages.getString("ReviewJob.task.updateReview"), 100);
            this.reviewInfo = this.processReviewInfo((IProgressMonitor)new SubProgressMonitor(monitor, 5));
            if (this.supportingDocuments.isEmpty()) {
                changesMonitor = new SubProgressMonitor(monitor, 95);
                supportingDocumentsMonitor = new NullProgressMonitor();
            } else {
                changesMonitor = new SubProgressMonitor(monitor, 75);
                supportingDocumentsMonitor = new SubProgressMonitor(monitor, 20);
            }
            String executionResultMsg = this.processChanges((IProgressMonitor)changesMonitor);
            changesMonitor.done();
            this.processSupportingDocumentsJson((IProgressMonitor)supportingDocumentsMonitor, this.reviewInfo);
            supportingDocumentsMonitor.done();
            returnStatus = executionResultMsg.length() == 0 ? Status.OK_STATUS : new MultiStatus("com.smartbear.collaborator", 0, new IStatus[]{new Status(2, "com.smartbear.collaborator", executionResultMsg)}, "Some warnings occurred trying to " + this.getName(), null);
        }
        catch (OperationCanceledException e) {
            returnStatus = Status.CANCEL_STATUS;
        }
        catch (Exception e2) {
            CollabClientException e2;
            String message = Strings.nullToEmpty((String)e2.getMessage());
            if (message.contains("Errors found:") && message.contains("InvalidAuthentication")) {
                e2 = new CollabClientException("Your login ticket is invalid.  Please try \"ccollab --use-json-api login\" on the command line and retry this command.");
            }
            returnStatus = new MultiStatus("com.smartbear.collaborator", 0, new IStatus[]{new Status(4, "com.smartbear.collaborator", 0, "Could not finish Review Job", (Throwable)e2)}, "An error occurred trying to " + this.getName(), null);
        }
        finally {
            monitor.done();
        }
        return returnStatus;
    }

    abstract ReviewInfo processReviewInfo(IProgressMonitor var1) throws CollabClientException;

    private String processChanges(IProgressMonitor monitor) throws CollabClientException, IOException {
        AbstractReviewCommand command = this.changes.getUploadCommand();
        command.setReview(this.reviewInfo.getReviewId().toString());
        Collaborator.executeJson((Command)command, this.currentUserInfo, this.changes.getScmOptions(), monitor);
        return command.getExecutionResultMessage().toString();
    }

    private void processSupportingDocumentsJson(IProgressMonitor monitor, ReviewInfo reviewInfo) throws CollabClientException, IOException {
        monitor.beginTask(Messages.getString("ReviewJob.task.supportingDocuments"), this.supportingDocuments.size() * 100);
        JsonBatchCommand jsonBatchSysAdminCommand = new JsonBatchCommand();
        CollaboratorJsonApi jsonApi = jsonBatchSysAdminCommand.getCollaboratorJsonApi();
        String binaryFilePatterns = jsonApi.systemAdminApi().systemApi().fileTypesApi().getBinaryFilePatterns();
        String restrictedFilePatterns = jsonApi.systemAdminApi().systemApi().fileTypesApi().getRestrictedFilePatterns();
        for (File file : this.supportingDocuments) {
            ScmChangeset changeSet = new ScmChangeset();
            IScmLocalCheckout checkout = ScmUtils.getUncontrolledFile((File)file);
            changeSet.addLocalCheckout(checkout, false, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            IScmClientConfiguration config = checkout.getClientConfiguration();
            IScmSystem system = config.getScmSystem();
            IScmConnectionParameters connectionParams = config.getServerConfiguration(checkout, null, null);
            AddFilesRequest request = (AddFilesRequest)JsonUtils.create(AddFilesRequest.class);
            request.setReviewId(reviewInfo.getReviewId());
            request.setChangelists(new ArrayList());
            File targetZipFile = PathUtils.createTempFile((String)"store-", (String)".zip");
            ArrayList<File> attachedFiles = new ArrayList<File>();
            attachedFiles.add(targetZipFile);
            ChangelistDescriptor changelist = Scm.buildChangeset((String)restrictedFilePatterns, (String)binaryFilePatterns, (Scm.ChangesetParameters)new Scm.ChangesetParameters(changeSet), (IScmSystem)system, (IScmConnectionParameters)connectionParams, (File)targetZipFile, (IProgressMonitor)monitor);
            request.getChangelists().add(changelist);
            int n = jsonApi.reviewApi().reviewMaterialsApi().addFiles(request, attachedFiles);
        }
        monitor.done();
    }

    public final ReviewInfo getReviewInfo() {
        if (this.getResult() == null) {
            throw new RuntimeException("AddToReview job is not done");
        }
        return this.reviewInfo;
    }
}

