/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.jobs;

import com.smartbear.ccollab.client.CollabClientServerConnectivityException;
import com.smartbear.ccollab.datamodel.client.IConversation;
import com.smartbear.ccollab.datamodel.client.IConversationProvider;
import com.smartbear.ccollab.datamodel.client.IReviewComment;
import com.smartbear.ccollab.datamodel.client.IReviewConversation;
import com.smartbear.ccollab.datamodel.client.IReviewFile;
import com.smartbear.ccollab.datamodel.client.NoLicenseAvailableException;
import com.smartbear.ccollab.datamodel.client.ReviewAccessException;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewFile;
import com.smartbear.ccollab.datamodel.client.listener.IConversationListener;
import com.smartbear.ccollab.datamodel.client.listener.IConversationProviderListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewConversationListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ConversationProviderAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewConversationAdapter;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.JsonAPIHandler;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.jobs.AbstractActionItemsRefreshJob;
import com.smartbear.collaborator.jobs.ClientModelRefreshJob;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class FileRefreshJob
extends ClientModelRefreshJob {
    private final IReviewFile file;
    private final Executor updateExecutor;
    private final Object family;

    public FileRefreshJob(IReviewFile file, Executor updateExecutor) {
        super(file.getName());
        this.file = file;
        this.updateExecutor = updateExecutor;
        this.family = FileRefreshJob.getReviewFamily(file.getId());
        this.addRefreshActionItemsListeners(file);
    }

    private void addRefreshActionItemsListeners(IReviewFile file) {
        ConversationProviderAdapter convoProviderListener = new ConversationProviderAdapter(){
            private final IConversationListener convoListener = new ReviewConversationAdapter(){

                public void commentsAdded(IReviewConversation conversation, ArrayList<? extends IReviewComment> newComments) {
                    AbstractActionItemsRefreshJob.refreshActionItems();
                }

                public void isReadChanged(IReviewConversation conversation, boolean isRead) {
                    AbstractActionItemsRefreshJob.refreshActionItems();
                }
            };

            public void conversationsAdded(IConversationProvider conversationProvider, ArrayList<? extends IConversation> newConversations) {
                for (IConversation iConversation : newConversations) {
                    iConversation.addConversationListener(this.convoListener);
                    ReviewConversationAdapter.init((IReviewConversation)((IReviewConversation)iConversation), (IReviewConversationListener)((IReviewConversationListener)this.convoListener));
                }
                AbstractActionItemsRefreshJob.refreshActionItems();
            }
        };
        file.addConversationProviderListener((IConversationProviderListener)convoProviderListener);
        ConversationProviderAdapter.init((IConversationProvider)file, (IConversationProviderListener)convoProviderListener);
    }

    @Override
    protected IStatus doRun(IProgressMonitor monitor) throws CollabClientServerConnectivityException {
        try {
            JsonAPIHandler.updateReviewFile((DMReviewFile)this.file, this.updateExecutor, true);
        }
        catch (ReviewAccessException e) {
            return new Status(4, "com.smartbear.collaborator", "No longer allowed to access Review #" + this.file.getId() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (NoLicenseAvailableException e) {
            return new Status(4, "com.smartbear.collaborator", e.getMessage(), (Throwable)e);
        }
        catch (CollabClientException e) {
            Collaborator.log((Exception)((Object)e));
            return new Status(2, "com.smartbear.collaborator", "File " + this.file.getName() + " removed from Review", (Throwable)e);
        }
        catch (ParseException e) {
            Collaborator.log(e);
            return new Status(2, "com.smartbear.collaborator", "File " + this.file.getName() + " removed from Review", (Throwable)e);
        }
        this.active = false;
        return Status.OK_STATUS;
    }

    @Override
    protected long getRefreshIntervalMillis() {
        return (long)this.file.getRefreshInterval() * 1000L;
    }

    @Override
    public boolean belongsTo(Object otherFamily) {
        return super.belongsTo(otherFamily) || this.family.equals(otherFamily);
    }
}

