/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.jobs;

import com.smartbear.ccollab.client.CollabClientServerConnectivityException;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.IConnectionConfigListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class RefreshJob
extends Job {
    private boolean shouldRun = false;
    private IStatus lastResult = Status.OK_STATUS;
    private final IConnectionConfigListener connectionConfigListener = new IConnectionConfigListener(){

        @Override
        public void connectionConfigChanged() {
            RefreshJob.this.start();
        }
    };

    public RefreshJob(String name) {
        super(name);
        this.setSystem(true);
        this.setPriority(30);
    }

    public boolean shouldRun() {
        return this.shouldRun;
    }

    public boolean shouldReschedule() {
        return true;
    }

    public void start() {
        this.shouldRun = true;
        this.schedule();
        this.wakeUp();
        Collaborator.addConnectionConfigListener(this.connectionConfigListener);
    }

    public void stop() {
        Collaborator.removeConnectionConfigListener(this.connectionConfigListener);
        this.shouldRun = false;
        this.cancel();
    }

    protected abstract long getRefreshIntervalMillis();

    protected IStatus run(IProgressMonitor monitor) {
        Throwable refreshException = null;
        boolean stopRefresh = false;
        try {
            this.lastResult = this.doRun(monitor);
        }
        catch (CollabClientServerConnectivityException | OperationCanceledException e) {
            refreshException = e;
            stopRefresh = this.shouldStopRefresh((Exception)e);
        }
        if (refreshException != null) {
            this.lastResult = new Status(2, "com.smartbear.collaborator", 0, "Could not connect to server to run " + this.getName(), refreshException);
            for (Job job : RefreshJob.getJobManager().find(Collaborator.JOB_FAMILY)) {
                if (job == this) continue;
                RefreshJob refreshJob = (RefreshJob)job;
                refreshJob.lastResult = new Status(2, "com.smartbear.collaborator", 0, "Could not connect to server to run " + refreshJob.getName(), refreshException);
                if (!stopRefresh) continue;
                refreshJob.stop();
            }
        }
        if (!monitor.isCanceled() && !stopRefresh && this.shouldReschedule()) {
            this.schedule(this.getRefreshIntervalMillis());
        } else {
            this.stop();
        }
        return this.lastResult;
    }

    private boolean shouldStopRefresh(Exception e) {
        return !(e instanceof CollabClientServerConnectivityException) || ((CollabClientServerConnectivityException)((Object)e)).getErrorType() != CollabClientServerConnectivityException.ConnectionErrorType.NETWORK_CONNECTION_ERROR;
    }

    protected abstract IStatus doRun(IProgressMonitor var1) throws CollabClientServerConnectivityException;

    public IStatus getLastResult() {
        return this.lastResult;
    }

    public boolean belongsTo(Object family) {
        return family == Collaborator.JOB_FAMILY;
    }
}

