/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.jobs;

import com.google.common.collect.Maps;
import com.smartbear.ccollab.client.CollabClientServerConnectivityException;
import com.smartbear.ccollab.datamodel.client.AssignmentState;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.IComment;
import com.smartbear.ccollab.datamodel.client.IConversationSummary;
import com.smartbear.ccollab.datamodel.client.IReviewComment;
import com.smartbear.ccollab.datamodel.client.IReviewConversation;
import com.smartbear.ccollab.datamodel.client.IReviewMovingOn;
import com.smartbear.ccollab.datamodel.client.IReviewSummary;
import com.smartbear.ccollab.datamodel.client.IReviewSummaryFile;
import com.smartbear.ccollab.datamodel.client.IScmMaterials;
import com.smartbear.ccollab.datamodel.client.IUser;
import com.smartbear.ccollab.datamodel.client.NoLicenseAvailableException;
import com.smartbear.ccollab.datamodel.client.Phase;
import com.smartbear.ccollab.datamodel.client.ReviewAccessException;
import com.smartbear.ccollab.datamodel.client.ReviewParticipantHelper;
import com.smartbear.ccollab.datamodel.client.ScmConsolidationMethod;
import com.smartbear.ccollab.datamodel.client.UserThreadState;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewSummary;
import com.smartbear.ccollab.datamodel.client.listener.ICommentListener;
import com.smartbear.ccollab.datamodel.client.listener.IConversationSummaryListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewConversationListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewMovingOnListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewSummaryFileListener;
import com.smartbear.ccollab.datamodel.client.listener.IReviewSummaryListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.CommentAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ConversationSummaryAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewConversationAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewMovingOnAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewSummaryAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewSummaryFileAdapter;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.JsonAPIHandler;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.jobs.AbstractActionItemsRefreshJob;
import com.smartbear.collaborator.jobs.ClientModelRefreshJob;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ReviewRefreshJob
extends ClientModelRefreshJob {
    private final IReviewSummary reviewSummary;
    private final Map<String, ScmConsolidationMethod> consolidationMethods = Maps.newHashMap();
    private final Executor updateExecutor;
    private final Object family;

    public ReviewRefreshJob(IReviewSummary reviewSummary, IClientSystemGlobals clientSystemGlobals, Executor updateExecutor) {
        super(reviewSummary.getName());
        this.reviewSummary = reviewSummary;
        this.updateExecutor = updateExecutor;
        this.family = ReviewRefreshJob.getReviewFamily(reviewSummary.getId());
        this.addRefreshActionItemsListeners(reviewSummary, clientSystemGlobals.getSelf());
    }

    private void addRefreshActionItemsListeners(IReviewSummary reviewSummary, IUser currentUser) {
        reviewSummary.getMovingOn().addMovingOnListener((IReviewMovingOnListener)new ReviewMovingOnAdapter(){

            public void phaseChanged(IReviewMovingOn movingOn, Phase phase) {
                AbstractActionItemsRefreshJob.refreshActionItems();
            }
        });
        reviewSummary.addReviewSummaryListener((IReviewSummaryListener)new ReviewParticipantHelper(currentUser){

            public void stateChanged(AssignmentState state) {
                AbstractActionItemsRefreshJob.refreshActionItems();
            }
        });
        ReviewSummaryAdapter.allHelper((IReviewSummary)reviewSummary).allConversations().addConversationListener((IReviewConversationListener)new ReviewConversationAdapter(){

            public void commentsAdded(IReviewConversation conversation, ArrayList<? extends IReviewComment> newComments) {
                AbstractActionItemsRefreshJob.refreshActionItems();
            }
        }, false);
        ReviewSummaryAdapter.allHelper((IReviewSummary)reviewSummary).allConversations().allComments().addCommentListener((ICommentListener)new CommentAdapter(){

            public void markedRead(IComment comment) {
                AbstractActionItemsRefreshJob.refreshActionItems();
            }
        }, false);
        ReviewSummaryAdapter.allHelper((IReviewSummary)reviewSummary).allMaterials().allChangelists().allFiles().addReviewSummaryFileListener((IReviewSummaryFileListener)new ReviewSummaryFileAdapter(){

            public void conversationsAdded(IReviewSummaryFile file, ArrayList<? extends IConversationSummary> addedConversations) {
                AbstractActionItemsRefreshJob.refreshActionItems();
            }
        }, false);
        ReviewSummaryAdapter.allHelper((IReviewSummary)reviewSummary).allMaterials().allChangelists().allFiles().allConversations().addConversationSummaryListener((IConversationSummaryListener)new ConversationSummaryAdapter(){

            public void stateChanged(IConversationSummary conversation, UserThreadState state) {
                AbstractActionItemsRefreshJob.refreshActionItems();
            }

            public void unreadStateChanged(IConversationSummary conversation, boolean isUnread) {
                AbstractActionItemsRefreshJob.refreshActionItems();
            }
        }, false);
    }

    @Override
    protected IStatus doRun(IProgressMonitor monitor) throws CollabClientServerConnectivityException {
        try {
            JsonAPIHandler.updateReviewSummary((DMReviewSummary)this.reviewSummary, this.consolidationMethods, this.updateExecutor, true);
        }
        catch (ReviewAccessException e) {
            return new Status(4, "com.smartbear.collaborator", "No longer allowed to access Review #" + this.reviewSummary.getId() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (NoLicenseAvailableException e) {
            return new Status(4, "com.smartbear.collaborator", e.getMessage(), (Throwable)e);
        }
        catch (CollabClientException e) {
            Collaborator.log((Exception)((Object)e));
            return new Status(2, "com.smartbear.collaborator", "Review " + this.reviewSummary.getId() + " deleted", (Throwable)e);
        }
        catch (ParseException e) {
            Collaborator.log(e);
            return new Status(2, "com.smartbear.collaborator", "Review " + this.reviewSummary.getId() + " deleted", (Throwable)e);
        }
        this.active = false;
        return Status.OK_STATUS;
    }

    @Override
    protected long getRefreshIntervalMillis() {
        return (long)this.reviewSummary.getRefreshInterval() * 1000L;
    }

    public void setConsolidationMethodAndRefresh(IScmMaterials materials, ScmConsolidationMethod consolidationMethod) {
        String key = materials.getId();
        if (materials.getDefaultConsolidationMethod() == consolidationMethod) {
            this.consolidationMethods.remove(key);
        } else {
            this.consolidationMethods.put(key, consolidationMethod);
        }
        this.start();
    }

    @Override
    public boolean belongsTo(Object otherFamily) {
        return super.belongsTo(otherFamily) || this.family.equals(otherFamily);
    }
}

