/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.preferences;

import com.smartbear.beans.ConfigUtils;
import com.smartbear.beans.GlobalOptions;
import com.smartbear.beans.IGlobalOptions;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.preferences.PrefsHelper;
import com.smartbear.util.commons.ObjectUtils;
import com.smartbear.utils.Hashing;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class GlobalOptionsMapper
extends AbstractPreferenceInitializer
implements IEclipsePreferences.IPreferenceChangeListener {
    private static IGlobalOptions options;
    private static final Map<String, IPrefMapper> PREFS_TO_OPTIONS;

    private static IGlobalOptions getGlobalOptions() {
        if (options == null) {
            try {
                options = (IGlobalOptions)ConfigUtils.loadConfigFiles().getA();
            }
            catch (IOException e) {
                Collaborator.log("Error loading global options", e);
                options = new GlobalOptions();
            }
        }
        return options;
    }

    public static void setGlobalOptions(IGlobalOptions options) {
        GlobalOptionsMapper.options = options;
    }

    private static void set(IEclipsePreferences prefs, String key, String value) {
        if (!StringUtils.isEmpty((String)value)) {
            prefs.put(key, value);
        } else {
            prefs.remove(key);
        }
    }

    private static void set(IEclipsePreferences prefs, String key, Boolean value) {
        if (value != null) {
            prefs.putBoolean(key, value.booleanValue());
        } else {
            prefs.remove(key);
        }
    }

    public static void initPrefsFromGlobalOptions(IEclipsePreferences prefs) {
        IGlobalOptions options = GlobalOptionsMapper.getGlobalOptions();
        try {
            URL url = options.getUrl();
            GlobalOptionsMapper.set(prefs, "url", url != null ? url.toExternalForm() : null);
            GlobalOptionsMapper.set(prefs, "user", options.getUser());
            GlobalOptionsMapper.set(prefs, "serverPassKey", Hashing.getSecureHash((byte[])StringUtils.defaultString((String)options.getPassword()).getBytes(), (boolean)true));
            GlobalOptionsMapper.set(prefs, "proxy", options.getServerProxyHost());
            GlobalOptionsMapper.set(prefs, "port", options.getServerProxyPort());
            GlobalOptionsMapper.set(prefs, "externalDiffSingleFileCommand", ConfigUtils.getExternalDiffSingleFileCommand());
            GlobalOptionsMapper.set(prefs, "externalDiffSingleFileArguments", ConfigUtils.getExternalDiffSingleFileCommandArgs());
            GlobalOptionsMapper.set(prefs, "externalDiffMultipleFilesCommand", ConfigUtils.getExternalDiffMultipleFilesCommand());
            GlobalOptionsMapper.set(prefs, "externalDiffMultipleFilesArguments", ConfigUtils.getExternalDiffMultipleFilesCommandArgs());
            GlobalOptionsMapper.set(prefs, "openreviewinbrowser", ConfigUtils.getOpenReviewInBrowser());
        }
        catch (Exception e) {
            Collaborator.log(e);
            prefs.put("url", ObjectUtils.toString((Object)options.getUrl(), (String)""));
            prefs.put("user", StringUtils.defaultString((String)options.getUser()));
            try {
                prefs.put("serverPassKey", StringUtils.defaultString((String)Hashing.getSecureHash((byte[])StringUtils.defaultString((String)options.getPassword()).getBytes(), (boolean)true)));
            }
            catch (GeneralSecurityException e1) {
                Collaborator.log(e1);
                prefs.put("serverPassKey", "");
            }
            prefs.put("proxy", StringUtils.defaultString((String)options.getServerProxyHost()));
            prefs.put("port", StringUtils.defaultString((String)options.getServerProxyPort()));
        }
    }

    public void initializeDefaultPreferences() {
        IEclipsePreferences defaultPrefs = new DefaultScope().getNode("com.smartbear.collaborator");
        GlobalOptionsMapper.initPrefsFromGlobalOptions(defaultPrefs);
        defaultPrefs.putBoolean("backgroundRefresh", true);
        defaultPrefs.putInt("actionRefresh", 5);
        defaultPrefs.putInt("fileHistory", 10);
        defaultPrefs.put("switchPerspective", "prompt");
        defaultPrefs.putBoolean("warnUnsupportedSCM", true);
        defaultPrefs.putBoolean("reviewInEclipse", true);
        defaultPrefs.putBoolean("openreviewinbrowser", true);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String prefKey = event.getKey();
        IPrefMapper prefMapper = PREFS_TO_OPTIONS.get(prefKey);
        if (prefMapper != null) {
            String value = Platform.getPreferencesService().getString("com.smartbear.collaborator", prefKey, "", null);
            prefMapper.save(value);
        }
    }

    static {
        PREFS_TO_OPTIONS = new HashMap<String, IPrefMapper>();
        PREFS_TO_OPTIONS.put("url", new GlobalOptionsPrefMapper("url"));
        PREFS_TO_OPTIONS.put("user", new GlobalOptionsPrefMapper("user"));
        PREFS_TO_OPTIONS.put("serverPassKey", new GlobalOptionsPrefMapper("server-pass-key"){

            @Override
            public void save(String value) {
                value = PrefsHelper.getPrefs().getPassword();
                try {
                    ConfigUtils.saveConfig((String)"password", (String)value);
                }
                catch (Exception e) {
                    Collaborator.log("Could not save global option 'password'", e);
                }
            }
        });
        PREFS_TO_OPTIONS.put("proxy", new GlobalOptionsPrefMapper("server-proxy-host"));
        PREFS_TO_OPTIONS.put("port", new GlobalOptionsPrefMapper("server-proxy-port"));
        PREFS_TO_OPTIONS.put("externalDiffSingleFileCommand", new IPrefMapper(){

            @Override
            public void save(String prefValue) {
                ConfigUtils.saveExternalDiffSingleFileCommand((File)new File(prefValue));
            }
        });
        PREFS_TO_OPTIONS.put("externalDiffSingleFileArguments", new IPrefMapper(){

            @Override
            public void save(String prefValue) {
                ConfigUtils.saveExternalDiffSingleFileCommandArgs((String)prefValue);
            }
        });
        PREFS_TO_OPTIONS.put("externalDiffMultipleFilesCommand", new IPrefMapper(){

            @Override
            public void save(String prefValue) {
                ConfigUtils.saveExternalDiffMultipleFilesCommand((File)new File(prefValue));
            }
        });
        PREFS_TO_OPTIONS.put("externalDiffMultipleFilesArguments", new IPrefMapper(){

            @Override
            public void save(String prefValue) {
                ConfigUtils.saveExternalDiffMultipleFilesCommandArgs((String)prefValue);
            }
        });
        PREFS_TO_OPTIONS.put("openreviewinbrowser", new IPrefMapper(){

            @Override
            public void save(String prefValue) {
                ConfigUtils.saveOpenReviewInBrowser((String)prefValue);
            }
        });
    }

    private static class GlobalOptionsPrefMapper
    implements IPrefMapper {
        private final String optionKey;

        public GlobalOptionsPrefMapper(String key) {
            this.optionKey = key;
        }

        @Override
        public void save(String value) {
            try {
                ConfigUtils.saveConfig((String)this.optionKey, (String)value);
            }
            catch (Exception e) {
                Collaborator.log("Could not save global option '" + this.optionKey + "'", e);
            }
        }
    }

    private static interface IPrefMapper {
        public void save(String var1);
    }
}

