/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.preferences;

import com.smartbear.beans.ConfigUtils;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.preferences.PrefsWrapper;
import com.smartbear.utils.Hashing;
import java.security.GeneralSecurityException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PrefsHelper {
    private static PrefsHelper defaultPrefsHelper;
    private PrefsWrapper prefsWrapper;

    public static IEclipsePreferences getEclipsePrefsNode() {
        return new InstanceScope().getNode("com.smartbear.collaborator");
    }

    public PrefsHelper(PrefsWrapper prefsWrapper) {
        this.prefsWrapper = prefsWrapper;
    }

    public static PrefsHelper getPrefs() {
        return defaultPrefsHelper;
    }

    public static void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        PrefsHelper.getEclipsePrefsNode().addPreferenceChangeListener(listener);
    }

    public static void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        PrefsHelper.getEclipsePrefsNode().removePreferenceChangeListener(listener);
    }

    public String getUrl() {
        return StringUtils.trim((String)this.prefsWrapper.getString("url"));
    }

    public String getUser() {
        return this.prefsWrapper.getString("user");
    }

    public String getPassword() {
        String password = this.prefsWrapper.getString("password", null);
        String serverPassKey = this.prefsWrapper.getString("serverPassKey", null);
        if (password != null) {
            return password;
        }
        if (serverPassKey != null) {
            String pth;
            byte[] ctb = Hashing.getBytesFromHex((String)serverPassKey);
            try {
                pth = Hashing.getSecureHash((byte[])ctb, (boolean)false);
            }
            catch (GeneralSecurityException e) {
                Collaborator.log(e);
                return null;
            }
            byte[] ptb = Hashing.getBytesFromHex((String)pth);
            return new String(ptb);
        }
        return null;
    }

    public String getHttpProxy() {
        return this.prefsWrapper.getString("proxy");
    }

    public String getHttpPort() {
        return this.prefsWrapper.getString("port");
    }

    public boolean shouldDecorateWorkspaceFiles() {
        return this.prefsWrapper.getBoolean("backgroundRefresh");
    }

    public long getActionRefresh() {
        return this.prefsWrapper.getLong("actionRefresh");
    }

    public boolean getActionOpenReviewInBrowser() {
        return this.prefsWrapper.getBoolean("openreviewinbrowser");
    }

    public String getSwitchPerspective() {
        return this.prefsWrapper.getString("switchPerspective");
    }

    public String getClientGuid() {
        return ConfigUtils.getClientGuid();
    }

    public boolean getWarnUnsupportedSCM() {
        return this.prefsWrapper.getBoolean("warnUnsupportedSCM");
    }

    public boolean getReviewInEclipse() {
        return this.prefsWrapper.getBoolean("reviewInEclipse");
    }

    public boolean getIgnoreWhiteSpaceInEclipseEditor() {
        return this.prefsWrapper.getBoolean("ignoreWhitespaceInEclipseEditor");
    }

    public boolean getIgnoreSequenceNumberInEclipseEditor() {
        return this.prefsWrapper.getBoolean("ignoreSequenceNumberInEclipseEditor");
    }

    public boolean getOverwriteTrustStoreInSSL() {
        return this.prefsWrapper.getBoolean("overwriteTrustStoreInSSL");
    }

    public long getFileHistoryDepth() {
        return this.prefsWrapper.getLong("fileHistory");
    }

    static {
        PrefsHelper.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                Collaborator.fireConnectionConfigChanged();
            }
        });
        defaultPrefsHelper = new PrefsHelper(new PrefsWrapper(){

            @Override
            public synchronized String getString(String key) {
                return this.getString(key, "");
            }

            @Override
            public synchronized String getString(String key, String defaultValue) {
                return Platform.getPreferencesService().getString("com.smartbear.collaborator", key, defaultValue, null);
            }

            @Override
            public synchronized long getLong(String key) {
                return Platform.getPreferencesService().getLong("com.smartbear.collaborator", key, 0L, null);
            }

            @Override
            public synchronized boolean getBoolean(String key) {
                return Platform.getPreferencesService().getBoolean("com.smartbear.collaborator", key, false, null);
            }
        });
    }
}

