/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.scm;

import com.google.common.collect.Lists;
import com.smartbear.beans.IAskUser;
import com.smartbear.beans.IScmOptions;
import com.smartbear.ccollab.client.commands.CommandAddChanges;
import com.smartbear.ccollab.client.commands.CommandNoop;
import com.smartbear.ccollab.client.commands.admin.review.AbstractReviewCommand;
import com.smartbear.ccollab.client.commands.argrefs.ILocalCheckoutsRef;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.scm.IScmChangeAdapter;
import com.smartbear.progress.IteratorWithProgress;
import com.smartbear.scm.IScmLocalCheckout;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractFilesChangeAdapter<F>
implements IScmChangeAdapter {
    private Collection<? extends IScmLocalCheckout> modifiedAndRevertedCheckouts;
    private Collection<F> files;
    private final IScmOptions options;

    public AbstractFilesChangeAdapter(Collection<? extends IScmLocalCheckout> modifiedAndRevertedCheckouts, Collection<F> files, IScmOptions options) {
        this.modifiedAndRevertedCheckouts = modifiedAndRevertedCheckouts;
        this.files = files;
        this.options = options;
    }

    @Override
    public String getDisplayContents() {
        int size;
        return size + " file" + ((size = this.modifiedAndRevertedCheckouts.size() + this.files.size()) == 1 ? "" : "s");
    }

    @Override
    public String getDisplayLabel() {
        return "Files";
    }

    @Override
    public AbstractReviewCommand getUploadCommand() {
        if (this.isEmpty()) {
            return CommandNoop.INSTANCE;
        }
        CommandAddChanges command = new CommandAddChanges();
        command.setFileSpecs(new ILocalCheckoutsRef[]{new ILocalCheckoutsRef(){

            public List<File> getResolvedPaths() {
                ArrayList resolvedPaths = Lists.newArrayListWithExpectedSize((int)(AbstractFilesChangeAdapter.this.modifiedAndRevertedCheckouts.size() + AbstractFilesChangeAdapter.this.files.size()));
                for (IScmLocalCheckout iScmLocalCheckout : AbstractFilesChangeAdapter.this.modifiedAndRevertedCheckouts) {
                    resolvedPaths.add(iScmLocalCheckout.getLocalPath());
                }
                for (Object object : AbstractFilesChangeAdapter.this.files) {
                    resolvedPaths.add(AbstractFilesChangeAdapter.this.getFile(object));
                }
                return resolvedPaths;
            }

            public List<IScmLocalCheckout> getCheckouts(IScmOptions options, IAskUser askUser, List<File> previouslyModifiedFiles, IProgressMonitor monitor) throws CollabClientException {
                ArrayList<IScmLocalCheckout> checkouts = new ArrayList<IScmLocalCheckout>();
                checkouts.addAll(AbstractFilesChangeAdapter.this.modifiedAndRevertedCheckouts);
                IteratorWithProgress itr = IteratorWithProgress.getIterator(AbstractFilesChangeAdapter.this.files, (String)"Getting unmodified files", (IProgressMonitor)monitor);
                while (itr.hasNext()) {
                    checkouts.add(AbstractFilesChangeAdapter.this.getCheckout(itr.next(), itr.getIterationProgressMonitor()));
                }
                return checkouts;
            }
        }});
        return command;
    }

    @Override
    public IScmOptions getScmOptions() {
        return this.options;
    }

    protected abstract File getFile(F var1);

    protected abstract IScmLocalCheckout getCheckout(F var1, IProgressMonitor var2) throws ScmCommunicationException;

    @Override
    public boolean isEmpty() {
        return this.modifiedAndRevertedCheckouts.isEmpty() && this.files.isEmpty();
    }
}

