/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.scm;

import com.smartbear.beans.IScmOptions;
import com.smartbear.ccollab.client.commands.CommandAddChangelist;
import com.smartbear.ccollab.client.commands.CommandNoop;
import com.smartbear.ccollab.client.commands.admin.review.AbstractReviewCommand;
import com.smartbear.ccollab.client.commands.argrefs.ChangelistRefByObject;
import com.smartbear.ccollab.client.commands.argrefs.IChangelistRef;
import com.smartbear.collaborator.scm.IScmChangeAdapter;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.util.SmartBearUtils;
import java.util.List;

public class ScmChangeAdapter
implements IScmChangeAdapter {
    String displayLabel;
    IScmChangelist[] changes;
    IScmOptions options;
    boolean postCommit;
    List<String> excludeMask;
    List<String> includeMask;

    public ScmChangeAdapter(IScmChangelist[] changes, String displayLabel, IScmOptions options) {
        this(changes, displayLabel, options, false);
    }

    public ScmChangeAdapter(IScmChangelist[] changes, String displayLabel, IScmOptions options, boolean postCommit) {
        this.changes = changes;
        this.displayLabel = displayLabel;
        this.options = options;
        this.postCommit = postCommit;
    }

    public ScmChangeAdapter(IScmChangelist[] changes, String displayLabel, IScmOptions options, boolean postCommit, List<String> exclude, List<String> include) {
        this.changes = changes;
        this.displayLabel = displayLabel;
        this.options = options;
        this.postCommit = postCommit;
        this.excludeMask = exclude;
        this.includeMask = include;
    }

    @Override
    public String getDisplayContents() {
        String displayContents;
        if (this.changes.length == 0) {
            displayContents = "";
        } else {
            StringBuffer buff = new StringBuffer();
            buff.append(this.changes[0].getId());
            for (int i = 1; i < this.changes.length; ++i) {
                buff.append(",");
                buff.append(this.changes[i].getId());
            }
            displayContents = buff.toString();
        }
        return displayContents;
    }

    @Override
    public String getDisplayLabel() {
        return this.displayLabel;
    }

    @Override
    public boolean isEmpty() {
        return this.changes.length == 0;
    }

    @Override
    public AbstractReviewCommand getUploadCommand() {
        if (this.isEmpty()) {
            return CommandNoop.INSTANCE;
        }
        CommandAddChangelist command = new CommandAddChangelist(((IScmChangelist)SmartBearUtils.getFirstObject((Object[])this.changes)).getClientConfiguration());
        IChangelistRef[] changeRefs = new IChangelistRef[this.changes.length];
        for (int i = 0; i < this.changes.length; ++i) {
            changeRefs[i] = new ChangelistRefByObject(this.changes[i]);
        }
        command.setPostCommit(Boolean.valueOf(this.postCommit));
        command.setChangelists(changeRefs);
        if (this.excludeMask != null && !this.excludeMask.isEmpty()) {
            command.setExclude(String.join((CharSequence)",", this.excludeMask));
        }
        if (this.includeMask != null && !this.includeMask.isEmpty()) {
            command.setInclude(String.join((CharSequence)",", this.includeMask));
        }
        command.setIgnoreEmptyChangelists(Boolean.valueOf(true));
        return command;
    }

    @Override
    public IScmOptions getScmOptions() {
        return this.options;
    }
}

