/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.subclipse;

import com.google.common.collect.Lists;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.progress.IOUtilsWithProgress;
import com.smartbear.progress.IteratorWithProgress;
import com.smartbear.scm.impl.subversion.AbstractSubversionClient;
import com.smartbear.scm.impl.subversion.IPathState;
import com.smartbear.scm.impl.subversion.ISubversionClient;
import com.smartbear.scm.impl.subversion.Info;
import com.smartbear.scm.impl.subversion.ListEntry;
import com.smartbear.scm.impl.subversion.LogEntry;
import com.smartbear.scm.impl.subversion.LogPath;
import com.smartbear.scm.impl.subversion.StatusEntry;
import com.smartbear.scm.impl.subversion.SubversionAccessForbiddenException;
import com.smartbear.scm.impl.subversion.SubversionNotVersionedResourceException;
import com.smartbear.scm.impl.subversion.SubversionNotWorkingCopyException;
import com.smartbear.util.commons.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.osgi.framework.Bundle;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNInfoUnversioned;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SubclipseSubversionClient
extends AbstractSubversionClient
implements ISubversionClient {
    protected final ISVNClientAdapter svnClient;
    public static final String ID = "com.smartbear.collaborator.subclipse";

    public static void log(IStatus status) {
        Platform.getLog((Bundle)Platform.getBundle((String)ID)).log(status);
    }

    public SubclipseSubversionClient(ISVNClientAdapter svnClient) {
        this.svnClient = svnClient;
    }

    public String getVersionInfo(IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] cat(String url, String pegRevision, String opRevision, IProgressMonitor monitor) throws ScmCommunicationException {
        byte[] bytes;
        monitor.beginTask("Running 'svn cat'", 100);
        InputStream contentStream = null;
        try {
            contentStream = this.svnClient.getContent(SubclipseSubversionClient.toSubclipseUrl(url), SubclipseSubversionClient.toSubclipseRevision(opRevision), SubclipseSubversionClient.toSubclipseRevision(pegRevision));
            monitor.worked(20);
            bytes = IOUtilsWithProgress.toByteArray((InputStream)contentStream, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
        }
        catch (SVNClientException e) {
            try {
                throw new ScmCommunicationException("Could not run 'cat': " + e.getMessage(), (Throwable)e);
                catch (IOException e2) {
                    throw new ScmCommunicationException("Could not run 'cat': " + e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(contentStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)contentStream);
        monitor.done();
        return bytes;
    }

    public void commit(Iterable<File> files, boolean recursive, String comment, IProgressMonitor monitor) throws ScmCommunicationException {
        try {
            this.svnClient.commit(Lists.newArrayList(files).toArray(new File[0]), comment, recursive);
        }
        catch (SVNClientException e) {
            throw new ScmCommunicationException("Could not run 'commit': " + e.getMessage(), (Throwable)e);
        }
    }

    protected Info toInfo(String fileName, ISVNInfo subclipseInfo, File workingCopy) throws ScmCommunicationException {
        SVNRevision.Number subclipseRevision;
        String schedule;
        String returnedInfoUrl = subclipseInfo.getUrlString();
        String rootRepositoryUrl = null;
        SVNUrl subclipseRepository = subclipseInfo.getRepository();
        if (subclipseRepository != null) {
            rootRepositoryUrl = subclipseRepository.toString();
        }
        String repositoryUUID = subclipseInfo.getUuid();
        IPathState.NodeKind nodeKind = SubclipseSubversionClient.toNodeKind(subclipseInfo.getNodeKind());
        try {
            schedule = subclipseInfo.getSchedule().toString();
        }
        catch (NullPointerException e) {
            SubclipseSubversionClient.log((IStatus)new Status(2, ID, 0, "Caught semi-expected NPE while attempting to get Subclipse revision schedule", (Throwable)e));
            schedule = null;
        }
        SVNUrl subclipseCopiedFromUrl = subclipseInfo.getCopyUrl();
        String copiedFromUrl = null;
        if (subclipseCopiedFromUrl != null) {
            copiedFromUrl = subclipseCopiedFromUrl.toString();
        }
        SVNRevision.Number subclipseCopiedFromRev = subclipseInfo.getCopyRev();
        int copiedFromRev = 0;
        if (subclipseCopiedFromRev != null) {
            copiedFromRev = (int)subclipseCopiedFromRev.getNumber();
        }
        SVNRevision.Number subclipseLastChangedRevision = subclipseInfo.getLastChangedRevision();
        int lastChangedRevision = 0;
        if (subclipseLastChangedRevision != null) {
            lastChangedRevision = (int)subclipseLastChangedRevision.getNumber();
        }
        int revision = (subclipseRevision = subclipseInfo.getRevision()) != null ? (int)subclipseRevision.getNumber() : lastChangedRevision;
        try {
            return new Info(workingCopy, fileName, returnedInfoUrl, rootRepositoryUrl, repositoryUUID, nodeKind, schedule, copiedFromUrl, (long)copiedFromRev, (long)revision, (long)lastChangedRevision, null);
        }
        catch (IllegalArgumentException e) {
            throw new ScmCommunicationException("Could not get info from Subclipse Info: " + subclipseInfo, (Throwable)e);
        }
    }

    public Info info(File file, IProgressMonitor monitor) throws ScmCommunicationException {
        ISVNInfo subclipseInfo;
        try {
            subclipseInfo = this.svnClient.getInfoFromWorkingCopy(file);
        }
        catch (SVNClientException e) {
            throw SubclipseSubversionClient.toScmException(file, e);
        }
        if (subclipseInfo instanceof SVNInfoUnversioned) {
            throw new SubversionNotVersionedResourceException(file, "'" + file + "' is not a versioned resource");
        }
        return this.toInfo(file.getName(), subclipseInfo, file);
    }

    public Info info(String url, String pegRevision, String opRevision, IProgressMonitor monitor) throws ScmCommunicationException {
        ISVNInfo subclipseInfo;
        SVNUrl subclipseUrl = SubclipseSubversionClient.toSubclipseUrl(url);
        SVNRevision subclipsePegRevision = SubclipseSubversionClient.toSubclipseRevision(pegRevision);
        SVNRevision subclipseOpRevision = SubclipseSubversionClient.toSubclipseRevision(opRevision);
        try {
            subclipseInfo = this.svnClient.getInfo(subclipseUrl, subclipseOpRevision, subclipsePegRevision);
        }
        catch (SVNClientException e) {
            throw new ScmCommunicationException("Could not get info for url: " + url + "@" + pegRevision + ", operative revision: " + opRevision, (Throwable)e);
        }
        String fileName = subclipseUrl.getLastPathSegment();
        fileName = StringUtils.defaultIfEmpty((String)fileName, (String)subclipseUrl.getHost());
        return this.toInfo(fileName, subclipseInfo, null);
    }

    public LogEntry[] log(String url, String pegRevision, String earliestRevision, String latestRevision, boolean includeFileList, int limit, String type, IProgressMonitor monitor) throws ScmCommunicationException {
        ISVNLogMessage[] subclipseLogEntries;
        try {
            subclipseLogEntries = this.svnClient.getLogMessages(SubclipseSubversionClient.toSubclipseUrl(url), SubclipseSubversionClient.toSubclipseRevision(pegRevision), SubclipseSubversionClient.toSubclipseRevision(latestRevision), SubclipseSubversionClient.toSubclipseRevision(earliestRevision), false, includeFileList, (long)limit);
        }
        catch (SVNClientException e) {
            if (StringUtils.containsIgnoreCase((String)e.getMessage(), (String)"forbidden")) {
                throw new SubversionAccessForbiddenException(e.getMessage());
            }
            throw new ScmCommunicationException("Could not run 'log': " + e.getMessage(), (Throwable)e);
        }
        return SubclipseSubversionClient.toLogEntries(subclipseLogEntries);
    }

    public List<StatusEntry> status(File file, boolean recursive, boolean getAll, boolean ignoreExternals, IProgressMonitor monitor) throws ScmCommunicationException, SubversionNotWorkingCopyException {
        ISVNStatus[] subclipseStatusEntries;
        try {
            subclipseStatusEntries = this.svnClient.getStatus(file, recursive, getAll, false, ignoreExternals);
        }
        catch (SVNClientException e) {
            throw SubclipseSubversionClient.toScmException(file, e);
        }
        ArrayList statusEntries = Lists.newArrayListWithExpectedSize((int)subclipseStatusEntries.length);
        for (ISVNStatus subclipseStatusEntry : subclipseStatusEntries) {
            StatusEntry.StatusCode statusCode = SubclipseSubversionClient.toStatusCode(subclipseStatusEntry.getTextStatus());
            char additionWithHistory = subclipseStatusEntry.isCopied() ? (char)'+' : ' ';
            char switchedCode = subclipseStatusEntry.isSwitched() ? (char)'S' : ' ';
            File statusEntryFile = subclipseStatusEntry.getFile();
            String revision = ObjectUtils.toString((Object)subclipseStatusEntry.getRevision());
            try {
                statusEntries.add(new StatusEntry(statusCode, additionWithHistory, switchedCode, statusEntryFile, revision));
            }
            catch (IllegalArgumentException e) {
                throw new ScmCommunicationException("Could not get status for file " + file + " from Subclipse", (Throwable)e);
            }
        }
        return statusEntries;
    }

    public void add(File file, boolean recurse, IProgressMonitor monitor) throws ScmCommunicationException, SubversionNotWorkingCopyException {
        try {
            if (file.isFile()) {
                this.svnClient.addFile(file);
            } else {
                this.svnClient.addDirectory(file, recurse);
            }
        }
        catch (SVNClientException e) {
            throw SubclipseSubversionClient.toScmException(file, e);
        }
    }

    public void add(Collection<File> files, boolean recurse, IProgressMonitor monitor) throws ScmCommunicationException, SubversionNotWorkingCopyException {
        IteratorWithProgress itr = IteratorWithProgress.getIterator(files, (String)"Adding files", (IProgressMonitor)monitor);
        while (itr.hasNext()) {
            this.add((File)itr.next(), recurse, itr.getIterationProgressMonitor());
        }
    }

    private static ScmCommunicationException toScmException(File file, SVNClientException e) {
        if (StringUtils.contains((String)e.getMessage(), (String)" was not found.") || StringUtils.contains((String)e.getMessage(), (String)"is not under version control")) {
            return new SubversionNotVersionedResourceException(file, "'" + file + "' is not a versioned resource");
        }
        if (StringUtils.contains((String)e.getMessage(), (String)" is not a working copy") || StringUtils.contains((String)e.getMessage(), (String)"Can't find a working copy path")) {
            return new SubversionNotWorkingCopyException(file, file + " is not a working copy", (Throwable)e);
        }
        if (!Locale.getDefault().getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            Collaborator.log((String)("Not sure how to parse non-English localized Subversion message.  Assuming '" + e.getMessage() + "' means 'file is not a working copy"));
            return new SubversionNotWorkingCopyException(file, e.getMessage(), (Throwable)e);
        }
        return new ScmCommunicationException("Subversion error for file: " + file, (Throwable)e);
    }

    protected static SVNUrl toSubclipseUrl(String url) throws ScmCommunicationException {
        SVNUrl subclipseUrl;
        try {
            subclipseUrl = new SVNUrl(url);
        }
        catch (MalformedURLException e) {
            throw new ScmCommunicationException((Exception)e);
        }
        return subclipseUrl;
    }

    protected static SVNRevision toSubclipseRevision(String revision) throws ScmCommunicationException {
        SVNRevision subclipseRevision;
        try {
            subclipseRevision = SVNRevision.getRevision((String)revision);
        }
        catch (ParseException e) {
            throw new ScmCommunicationException("Could not convert " + revision + " to a Subclipse revision", (Throwable)e);
        }
        return subclipseRevision;
    }

    protected static LogEntry toLogEntry(ISVNLogMessage subclipseLogEntry) throws ScmCommunicationException {
        LogEntry logEntry;
        long revision = subclipseLogEntry.getRevision().getNumber();
        String author = StringUtils.defaultString((String)subclipseLogEntry.getAuthor());
        Date date = subclipseLogEntry.getDate();
        String comment = StringUtils.defaultString((String)subclipseLogEntry.getMessage());
        ISVNLogMessageChangePath[] subclipseLogPaths = subclipseLogEntry.getChangedPaths();
        LogPath[] paths = new LogPath[subclipseLogPaths.length];
        for (int j = 0; j < subclipseLogPaths.length; ++j) {
            ISVNLogMessageChangePath subclipseLogPath = subclipseLogPaths[j];
            String relativeUrl = subclipseLogPath.getPath();
            char svnStatus = subclipseLogPath.getAction();
            String copiedFromUrl = subclipseLogPath.getCopySrcPath();
            SVNRevision.Number subclipseCopiedFromRevision = subclipseLogPath.getCopySrcRevision();
            int copiedFromRevision = 0;
            if (subclipseCopiedFromRevision != null) {
                copiedFromRevision = (int)subclipseCopiedFromRevision.getNumber();
            }
            try {
                paths[j] = new LogPath(relativeUrl, revision, svnStatus, copiedFromUrl, (long)copiedFromRevision, null);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new ScmCommunicationException("Could not get log path for changePath " + subclipseLogPath + " from Subclipse", (Throwable)e);
            }
        }
        try {
            logEntry = new LogEntry(revision, author, date, comment, paths);
        }
        catch (IllegalArgumentException e) {
            throw new ScmCommunicationException("Could not get log entry: " + e.getMessage(), (Throwable)e);
        }
        return logEntry;
    }

    protected static LogEntry[] toLogEntries(ISVNLogMessage[] subclipseLogEntries) throws ScmCommunicationException {
        LogEntry[] logEntries = new LogEntry[subclipseLogEntries.length];
        for (int i = 0; i < subclipseLogEntries.length; ++i) {
            logEntries[i] = SubclipseSubversionClient.toLogEntry(subclipseLogEntries[i]);
        }
        return logEntries;
    }

    protected static IPathState.NodeKind toNodeKind(SVNNodeKind subclipseNodeKind) throws ScmCommunicationException {
        if (subclipseNodeKind.equals((Object)SVNNodeKind.DIR)) {
            return IPathState.NodeKind.DIRECTORY;
        }
        if (subclipseNodeKind.equals((Object)SVNNodeKind.FILE)) {
            return IPathState.NodeKind.FILE;
        }
        if (subclipseNodeKind.equals((Object)SVNNodeKind.NONE)) {
            return IPathState.NodeKind.NONE;
        }
        if (subclipseNodeKind.equals((Object)SVNNodeKind.UNKNOWN)) {
            return IPathState.NodeKind.UNKNOWN;
        }
        throw new ScmCommunicationException("Unrecognized node kind: " + subclipseNodeKind);
    }

    protected static StatusEntry.StatusCode toStatusCode(SVNStatusKind subclipseStatusKind) throws ScmCommunicationException {
        if (subclipseStatusKind.equals((Object)SVNStatusKind.NORMAL)) {
            return StatusEntry.StatusCode.NORMAL;
        }
        if (subclipseStatusKind.equals((Object)SVNStatusKind.NONE)) {
            return StatusEntry.StatusCode.NONE;
        }
        if (subclipseStatusKind.equals((Object)SVNStatusKind.ADDED)) {
            return StatusEntry.StatusCode.ADDED;
        }
        if (subclipseStatusKind.equals((Object)SVNStatusKind.MISSING)) {
            return StatusEntry.StatusCode.MISSING;
        }
        if (subclipseStatusKind.equals((Object)SVNStatusKind.DELETED)) {
            return StatusEntry.StatusCode.DELETED;
        }
        if (subclipseStatusKind.equals((Object)SVNStatusKind.REPLACED)) {
            return StatusEntry.StatusCode.REPLACED;
        }
        if (subclipseStatusKind.equals((Object)SVNStatusKind.MODIFIED)) {
            return StatusEntry.StatusCode.MODIFIED;
        }
        if (subclipseStatusKind.equals((Object)SVNStatusKind.MERGED)) {
            return StatusEntry.StatusCode.MERGED;
        }
        if (subclipseStatusKind.equals((Object)SVNStatusKind.CONFLICTED)) {
            return StatusEntry.StatusCode.CONFLICTED;
        }
        if (subclipseStatusKind.equals((Object)SVNStatusKind.OBSTRUCTED)) {
            return StatusEntry.StatusCode.OBSTRUCTED;
        }
        if (subclipseStatusKind.equals((Object)SVNStatusKind.INCOMPLETE)) {
            return StatusEntry.StatusCode.INCOMPLETE;
        }
        if (subclipseStatusKind.equals((Object)SVNStatusKind.IGNORED)) {
            return StatusEntry.StatusCode.IGNORED;
        }
        if (subclipseStatusKind.equals((Object)SVNStatusKind.EXTERNAL)) {
            return StatusEntry.StatusCode.EXTERNAL;
        }
        if (subclipseStatusKind.equals((Object)SVNStatusKind.UNVERSIONED)) {
            return StatusEntry.StatusCode.UNVERSIONED;
        }
        throw new ScmCommunicationException("Unrecognized status kind: " + subclipseStatusKind.toString());
    }

    public List<ListEntry> list(String directoryUrl, String revision, IProgressMonitor monitor) throws ScmCommunicationException {
        ISVNDirEntry[] dirEntrys;
        SVNRevision subclipseRevision = SubclipseSubversionClient.toSubclipseRevision(revision);
        SVNUrl subclipseUrl = SubclipseSubversionClient.toSubclipseUrl(directoryUrl);
        SubclipseSubversionClient.log((IStatus)new Status(2, ID, 0, subclipseUrl.toString() + " ... " + subclipseRevision.toString(), null));
        try {
            dirEntrys = this.svnClient.getList(subclipseUrl, subclipseRevision, subclipseRevision, true);
        }
        catch (SVNClientException e) {
            throw new ScmCommunicationException((Exception)((Object)e));
        }
        ArrayList<ListEntry> results = new ArrayList<ListEntry>();
        for (ISVNDirEntry entry : dirEntrys) {
            IPathState.NodeKind kind = SubclipseSubversionClient.toNodeKind(entry.getNodeKind());
            results.add(new ListEntry(entry.getPath(), kind));
        }
        return results;
    }
}

