// It's typically a bad idea to use these directly; the DOM
// should be scanned directly in the manner of autoconf.  However,
// sometimes we need to take advantage of properties of specific
// browsers, in which case these should be used.
var isMozilla = typeof window.innerWidth != 'undefined';
var isIE = ! isMozilla;

// create getElementById if it doesn't exist and document.all does exist
if(document.all && !document.getElementById) 
{
	document.getElementById = function(id) 
		{ return document.all[id]; }
}

// Finds a single element by ID or NAME, or null if cannot be found
function findElement( name )
{
	var el = document.getElementById( name );
	if ( ! el && !! document.getElementByName )
		el = document.getElementByName( name );
	else if ( ! el && document.getElementsByName )
	{
		var els = document.getElementsByName( name );
		if ( els != null && els.length > 0 )
			el = els[0];
	}
	return el;
}


// Given an array of objects, compute the outer rectangle containing all of them,
// returning this as left, top, right, bottom
function getContainingRectangle( els )
{
	var left = 999999;
	var top = 999999;
	var right = -1;
	var bottom = -1;
	for( k=0 ; k<els.length ; ++k )
	{
		var el = els[k];
		if ( el.offsetLeft < left )
			left = el.offsetLeft;
		if ( el.offsetTop < top )
			top = el.offsetTop;
		if ( el.offsetLeft + el.offsetWidth > right )
			right = el.offsetLeft + el.offsetWidth;
		if ( el.offsetTop + el.offsetHeight > bottom )
			bottom = el.offsetTop + el.offsetHeight;
	}
	var rect = new Object();
	rect.left = left;
	rect.top = top;
	rect.right = right;
	rect.bottom = bottom;
	return rect;
}

// Determine the width, height, scrollX and scrollY of the given window
function getWindowGeometry( w )
{
	var result = new Object();
	var d = w.document;
	
	// width and height
	if (typeof w.innerWidth!='undefined')
	{
		result.width = w.innerWidth;
		result.height = w.innerHeight;
	}
	else if (d.documentElement && typeof d.documentElement.clientWidth!='undefined' && d.documentElement.clientWidth!=0)
	{
		result.width = d.documentElement.clientWidth;
		result.height = d.documentElement.clientHeight;
	}
	else if (d.body && typeof d.body.clientWidth!='undefined')
	{
		result.width = d.body.clientWidth;
		result.height = d.body.clientHeight;
	}
	
	// offsetX and offsetY
	if (typeof w.pageXOffset!='undefined')
	{
		result.offsetX = w.pageXOffset;
		result.offsetY = w.pageYOffset;
	}
	else if (d.documentElement && typeof d.documentElement.pageXOffset!='undefined' )
	{
		result.offsetX = d.documentElement.pageXOffset;
		result.offsetY = d.documentElement.pageYOffset;
	}
	else if (d.body && typeof d.documentElement.scrollLeft!='undefined' && d.documentElement.scrollTop != 0)
	{
		result.offsetX = d.documentElement.scrollLeft;
		result.offsetY = d.documentElement.scrollTop;
	}
	else if (d.body && typeof d.body.scrollLeft!='undefined')
	{
		result.offsetX = d.body.scrollLeft;
		result.offsetY = d.body.scrollTop;
	}
	
	// done
	return result;
}

// debugging utilitiy to display all the key/value pairs in an object
// Optional second parameter filters fields for those that start with a substring
function showNameValuePairs( obj, startsWith )
{
	var result = "";
	var count = 0;
	for( key in obj )
	{
		if ( ! startsWith || key.substr( 0, startsWith.length ) == startsWith )
		{
			try
			{
				result += key + "=" + obj[key] + "\n";
				if ( ++count > 10 )
				{
					alert( result + "..........." );
					result = "";
					count = 0;
				}
			} catch ( e ) {}
		}
	}
	alert( result + "[[[EOF]]]" );
}

function newImage( src )
{
	if ( document.images )
	{
		var img = new Image();
		img.src = src;
		return img;
	}
}
